# -*- coding: utf-8 -*-

import datetime


def next_datetime_with_hour(hour):
    """Возвращает ближайшее время, когда будет ровно hour часов.
       Например, если сейчас 10.10.2010 16:35 и вызов с hour=17, вернётся 10.10.2010 17:00
       Например, если сейчас 10.10.2010 16:35 и вызов с hour=16, вернётся 11.10.2010 16:00
    """
    now = datetime.datetime.now()
    requested_time = datetime.time(hour=hour)
    if now.time() < requested_time:
        return datetime.datetime.combine(now, requested_time)
    else:
        return datetime.datetime.combine(now + datetime.timedelta(days=1), requested_time)


class SafeTimestampDateTime(datetime.datetime):
    @classmethod
    def fromtimestamp(cls, ts, tz=None):
        if isinstance(ts, basestring):
            # Первая конвертация только если передали строку
            # (если float - оставляем как есть, чтобы точно передать данные)
            ts = int(ts)
        try:
            dt = super(SafeTimestampDateTime, cls).fromtimestamp(ts, tz)
        except ValueError:
            # Если timestamp вне диапазона допустимых значений, то отдаем его как нулевой timestamp
            # при этом храним оригинальное значение timestamp'а
            dt = super(SafeTimestampDateTime, cls).fromtimestamp(0)
        # В MPFS везде используем int - поэтому далее приводим к int
        dt._timestamp = int(ts)
        return dt

    def get_timestamp(self):
        return self._timestamp
