# -*- coding: utf-8 -*-
"""

MPFS
CORE

Преобразователь системных имен

"""
from socket import gethostname

from mpfs.config import settings


HOST = filter(None, gethostname().split('.')).pop(0)


def dbuid(username):
    if settings.feature_toggles['custom_db_names']:
        return '%s_%s' % (username, HOST)
    return username


def dbname(name):
    if settings.feature_toggles['custom_db_names']:
        return '%s_%s' % (name, HOST)
    return name
