# -*- coding: utf-8 -*-

"""
DEPRECATED! DONT USE IT!
"""
import ConfigParser
import io

from mpfs.common.util import filetypes


raw_mimes_conf = """
[zip]
mimes=application/gzip,application/x-gzip,application/x-gunzip,application/gzipped,application/x-bzip2,application/x-bz2,application/zip,application/x-compressed,application/x-zip-compressed
exts=zip
docviewer=0
type=compressed

[rar]
mimes=application/rar,application/x-rar,application/x-rar-compressed,compressed/rar
exts=rar
docviewer=0
type=compressed

[xls]
mimes=application/vnd.ms-excel,application/x-msexcel,application/x-ms-excel,application/x-excel,application/xls,application/x-xls,application/vnd.openxmlformats-officedocument.spreadsheetml.sheet,application/vnd.sun.xml.calc,application/vnd.sun.xml.calc.template,application/x-vnd.oasis.opendocument.spreadsheet,application/x-vnd.oasis.opendocument.spreadsheet-template,application/msexcel,application/x-dos_ms_excel
exts=xls,xlsx,ods,xlt
docviewer=1
type=document

[csv]
mimes=text/csv,text/comma-separated-values
exts=csv
docviewer=1
type=document

[pdf]
mimes=application/pdf,application/x-pdf,application/acrobat,applications/vnd.pdf,text/pdf,text/x-pdf
exts=pdf
docviewer=1
type=document

[ppt]
mimes=application/mspowerpoint,application/ms-powerpoint,application/mspowerpnt,application/vnd-mspowerpoint,application/vnd.ms-powerpoint,application/powerpoint,application/x-powerpoint,application/x-mspowerpoint,application/vnd.openxmlformats-officedocument.presentationml.presentation,
exts=ppt,pptx,odp
docviewer=1
type=document

[qt]
mimes=video/qt,video/mov
exts=mov,qt
docviewer=0
type=video

[doc]
mimes=application/msword,application/rtf,application/vnd.openxmlformats-officedocument.wordprocessingml.document,application/vnd.sun.xml.writer,application/vnd.sun.xml.writer.template,application/vnd.oasis.opendocument.text,application/x-vnd.oasis.opendocument.text,application/doc,application/vnd.msword,application/vnd.ms-word,application/winword,application/word,application/x-msw6,application/x-msword,text/rtf,application/vnd.oasis.opendocument.text
exts=doc,docx,odt,rtf,docm,dotx,dot,dotm
docviewer=1
type=document

[image]
#mimes=image/,image/gif,image/jpeg,image/jpg,image/png,image/x-png,image/tiff,application/x-shockwave-flash,application/postscript,application/futuresplash,image/vnd.adobe.photoshop,image/photoshop,image/x-photoshop,image/psd,application/photoshop,application/psd,zz-application/zz-winassoc-psd
mimes=image/tiff,application/x-shockwave-flash,application/postscript,application/futuresplash,image/vnd.adobe.photoshop,image/photoshop,image/x-photoshop,image/psd,application/photoshop,application/psd,zz-application/zz-winassoc-psd
#exts=jpg,jpeg,pjpeg,gif,png,jpe,tiff,tif,ps,eps,psd,ai,cdr
exts=tiff,tif,ps,eps,psd,ai,cdr,nef,dng
docviewer=1
type=image


[mail]
mimes=message/
exts=
docviewer=0
type=

[video]
mimes=video/
exts=avi,wmv
docviewer=0
type=video

[audio]
mimes=audio/
exts=mp3
docviewer=0
type=audio

[application]
mimes=application/x-executable,application/x-dosexec,application/x-msdownload,application/exe,application/x-exe,application/dos-exe,application/x-msdos-program,application/msdos-windows,application/x-winexe,vms/exe
exts=exe,bat
docviewer=0
type=application

[text]
mimes=
exts=ini,log,asc,txt
docviewer=1
type=
"""

raw_icons_conf = """
[file_icons]
definitive=doc,ppt,xls,rtf,odt,ods,odp,pdf,psd,ai,png,gif,bmp,wma,mp3,pls,avi,mov,zip,txt,csv,tiff,jpg
general=image,audio,video,archive,text,font,executable,flash,development
default=none

doc=docx,doc,dotx
xls=xls,xlsx
ppt=ppt,pptx
jpg=jpeg,jpg
tiff=tiff,tif
"""

raw_docviewer_conf = """
[doc]
exts=docx,docm,doc,dotx,dot,dotm
url = https://word-view.officeapps.live.com/wv/wordviewerframe.aspx?ui=en-us&rs=en-us&WOPIsrc=https://docviewer.yandex.ru/disk/wopi/files/%s&access_token=%s

[ppt]
exts=pptx,ppsx,ppt,pot,pps,pptm,potm,potx,ppsm
url = https://powerpoint.officeapps.live.com/p/PowerPointFrame.aspx?ui=en-us&rs=en-us&PowerPointView=ReadingView&WOPIsrc=https://docviewer.yandex.ru/disk/wopi/files/%s&access_token=%s

[xls]
exts=xlsx,xlsm,xlsb,xls
url = https://excel.officeapps.live.com/x/_layouts/xlviewerinternal.aspx?ui=en-us&rs=en-us&WOPIsrc=https://docviewer.yandex.ru/disk/wopi/files/%s&access_token=%s

[image]
exts=jpg,jpeg,pjpeg,gif,bmp,png,jpe

[pdf]
exts=pdf
"""

mime_config = ConfigParser.RawConfigParser(allow_no_value=True)
icons_config = ConfigParser.RawConfigParser(allow_no_value=True)
docviewer_config = ConfigParser.RawConfigParser(allow_no_value=True)
mime_config.readfp(io.BytesIO(raw_mimes_conf))
icons_config.readfp(io.BytesIO(raw_icons_conf))
docviewer_config.readfp(io.BytesIO(raw_docviewer_conf))

mimes = {}
exts = {}
icons = {}

for each in mime_config.sections():
    for mme in mime_config.get(each, 'mimes').split(','):
        mimes[mme] = {
                      'dtype' : each,
                      'type' : mime_config.get(each, 'type'),
                      }
    for ex in mime_config.get(each, 'exts').split(','):
        exts[ex] = {
                    'dtype' : each,
                    'type' : mime_config.get(each, 'type'),
                    }

for section_name in icons_config.sections():
    icons[section_name] = {
                           'definitive' : {},
                           'general' : set(icons_config.get(section_name, 'general').split(',')),
                           'default' : icons_config.get(section_name, 'default'),
                           }
    definitive_icons = icons_config.get(section_name, 'definitive').split(',')
    for each in definitive_icons:
        if icons_config.has_option(section_name, each):
            icons['file_icons']['definitive'].update(dict((_ext, each) for _ext in icons_config.get(section_name, each).split(',')))
        else:
            icons['file_icons']['definitive'][each] = each


def get_docviewer_type(**kw):
    docv_type = (by_mime(kw.get('mime')) or by_ext(kw.get('ext'))).get('dtype')
    if docv_type:
        try:
            readable = int(mime_config.get(docv_type, 'docviewer'))
        except Exception:
            readable = 0
        if readable:
            return docv_type
    return ''


def find_mime(**kw):
    '''
    get_class(mime='application/zip', ext='old_specifications.zip')
    '''
    return by_mime(kw.get('mime')) or by_ext(kw.get('ext'))


def by_mime(mme):
    if mme and '/' in mme: #mimetype
        return mimes.get(mme, {})


def by_ext(ext):
    if ext: #guess filename or extension
        ext = ext.lower().split('.')[-1]
        return exts.get(ext, {})

def get_ready(ext):
    if ext:
        ext = ext.lower().split('.')[-1]
    try:
        result = int(ext in docviewer_config.get(by_ext(ext).get('dtype'), 'exts'))
    except Exception:
        result = 0
    return result

def get_icon_val(filename, mime, group):
    groups_map = {
                 'compressed' : 'archive',
                 }
    result = icons['file_icons']['default']
    file_ext = filter(None, filename.split('.'))
    if file_ext and file_ext[-1].lower() in icons['file_icons']['definitive']:
        result = icons['file_icons']['definitive'][file_ext[-1].lower()]
    else:
        coincidences = None
        if mime:
            coincidences = filter(lambda file_ext: file_ext in icons['file_icons']['definitive'],
                                  filetypes.getExtensionsForMime(mime))
        if coincidences:
            result = icons['file_icons']['definitive'][coincidences[-1]]
        else:
            group = groups_map.get(group, group)
            if group and group in icons['file_icons']['general']:
                result = group
    return result
