# -*- coding: utf-8 -*-

import mpfs.engine.process

from mpfs.core.bus import Bus
from mpfs.core.filesystem.helpers.lock import LockHelper, LockUpdateTimer


log = mpfs.engine.process.get_default_log()


def remove_resource(address):
    log.info('removing %s' % address.id)

    LockHelper().check(address.id)
    timer = LockUpdateTimer(addresses=[address])
    try:
        timer.start()
        Bus().rm(address.uid, address.id)
    finally:
        timer.stop()

    log.info('removed %s' % address.id)


def copy_resource(source_address, target_address, autosuffix=False):
    if autosuffix:
        target_address = Bus().autosuffix_address(target_address)

    log.info('copying %s to %s' % (source_address.id, target_address.id))

    LockHelper().check(source_address.id)
    LockHelper().check(target_address.id)
    timer = LockUpdateTimer(addresses=[source_address, target_address])
    try:
        timer.start()
        Bus().copy_resource(target_address.uid, source_address.id, target_address.id, False, src_uid=source_address.uid)
    finally:
        timer.stop()

    log.info('copied %s to %s' % (source_address.id, target_address.id))
