# -*- coding: utf-8 -*-
"""

MPFS
CORE

Генераторы случайных чисел

"""
import random
import hashlib
import uuid

import mpfs.engine.process


def md5(*args):
    md5 = hashlib.md5()
    md5.update(str(random.random()))

    for arg in args:
        md5.update(str(arg))

    return md5.hexdigest()


def sha256(*args):
    sha256 = hashlib.sha256()
    sha256.update(str(random.random()))

    for arg in args:
        sha256.update(str(arg))

    return sha256.hexdigest()


def integer(range):
    return str(int(random.uniform(1, range)))


def cloud_request_id():
    return 'mpfs-%s-%s' % (uuid.uuid4().get_hex(), mpfs.engine.process.host())
