# -*- coding: utf-8 -*-
from mpfs.common.errors import APIError
from mpfs.common.static import codes


class LimitExceeded(APIError):
    pass


class UploadFileSizeLimitExceeded(LimitExceeded):
    code = codes.UPLOAD_FILE_SIZE_LIMIT_EXCEEDED


class UploadTrafficLimitExceeded(LimitExceeded):
    code = codes.UPLOAD_TRAFFIC_LIMIT_EXCEEDED


class UploadTrafficLimitWithoutDetailsError(LimitExceeded):
    code = codes.UPLOAD_TRAFFIC_LIMIT_WITHOUT_DETAILS
