# -*- coding: utf-8 -*-
from collections import namedtuple

from enum import Enum

UploadLimitPeriod = namedtuple('UploadLimitPeriod', ['name', 'counter_key', 'days_delta'])


class UploadLimitPeriods(Enum):
    DAILY = UploadLimitPeriod('daily', 'daily_upload_traffic', -1)
    WEEKLY = UploadLimitPeriod('weekly', 'weekly_upload_traffic', -7)
    MONTHLY = UploadLimitPeriod('monthly', 'monthly_upload_traffic', -30)
