# -*- coding: utf-8 -*-
"""

MPFS
CORE

Загрузчик модулей и классов

"""


def import_class(klass):
    module_name = '.'.join(klass.split('.')[:-1])
    class_name  = klass.split('.')[-1:].pop()
    module = import_module(module_name)
    return getattr(module, class_name)
    
def import_module(name):
    mod = __import__(name)
    components = name.split('.')
    for comp in components[1:]:
        mod = getattr(mod, comp)
    return mod

