# -*- coding: utf-8 -*-
import re


class MobileClientVersion(object):
    """
    Версия мобильного клиента

    Версией мобильного клиента являются первые два числа, разделенные точкой, на остальные разряды не смотрим.
    """
    VERSION_PATTERN = re.compile(r'^((\d+)\.(\d+))(([.-]\d+)|(\.\d+-\d+))?$')

    def __init__(self, version_tuple, version_str):
        self.version_tuple = version_tuple
        self.version_str   = version_str

    @classmethod
    def build_from_version(cls, full_version_str):
        match = cls.VERSION_PATTERN.match(full_version_str)
        if not match:
            return None
        return cls(version_tuple=(int(match.group(2)), int(match.group(3))), version_str=match.group(1))

    def get_without_build(self):
        return self.version_str

    def __cmp__(self, other):
        return cmp(self.version_tuple, other.version_tuple)
