# -*- coding: utf-8 -*-


import re
import copy


def try_int(s):
    "Convert to integer if possible."
    try: return int(s)
    except Exception: return s

def natsort_key(s):
    "Used internally to get a tuple by which s is sorted."
    return map(try_int, re.findall(r'(\d+|\D+)', s))

def natcmp(a, b):
    "Natural string comparison, case sensitive."
    nska = natsort_key(a)
    nskb = natsort_key(b)
    return (cmp(nska, nskb) if not nska == nskb else cmp(a, b))

def natcasecmp(a, b):
    "Natural string comparison, ignores case."
    return natcmp(a.lower(), b.lower())

def natsort(seq, cmp=natcasecmp):
    "In-place natural string sort."
    seq.sort(cmp)

def natsorted(seq, cmp=natcmp):
    "Returns a copy of seq, sorted by natural string sort."
    temp = copy.copy(seq)
    natsort(temp, cmp)
    return temp

def get_extension(name):
    if '.' in name:
        parts = filter(None, name.split('.'))
        if parts:
            return parts[-1].lower()
    return ''
