# -*- coding: utf-8 -*-

def check_path_forbidden_symbols(path):
    if not path:
        return

    bad_symbols = {u'\u0000'}

    for symbol in path:
        if symbol in bad_symbols:
            raise ValueError('found unsupported symbol "%(symbol)s"(u%(code)s}) in %(param)s.'
                             % {'symbol': symbol,
                                'code': hex(ord(symbol)),
                                'param': path})
