# -*- coding: utf-8 -*-


def smart_str(s, encoding='utf-8', errors='strict'):
    """Возвратить байтовое представление строки `s` в кодировке `encoding`.

    Параметр `errors` определяет что следует сделать в случае ошибки кодирования.
    Возможные значения: strict (raise ошибки), replace (замена на REPLACEMENT символ),
    ignore (просто не добавлять в результат).
    Подробнее: https://docs.python.org/2/howto/unicode.html#the-unicode-type.
    """
    if isinstance(s, bytes):
        if encoding == 'utf-8':
            return s
        else:
            return s.decode('utf-8', errors).encode(encoding, errors)
    return s.encode(encoding, errors)

