# -*- coding: utf-8 -*-
import threading


class ThreadedActionRepeater(threading.Thread):
    """
    Класс для выполнения повторяющегося действия в отдельном потоке
    """
    def __init__(self, interval, daemon=True, delay_first_action=True):
        super(ThreadedActionRepeater, self).__init__()
        self._stop_flag = threading.Event()
        self.daemon = daemon
        self._delay_first_action = delay_first_action
        self._interval = interval

    def stop(self):
        self._stop_flag.set()

    def run(self):
        if self._delay_first_action:
            self._stop_flag.wait(self._interval)

        while not self._stop_flag.is_set():
            self.action()
            self._stop_flag.wait(self._interval)

    def action(self):
        raise NotImplementedError()

    def __enter__(self):
        self.start()

    def __exit__(self, exc_type, exc_val, exc_tb):
        self.stop()
