# -*- coding: utf-8 -*-

from __future__ import unicode_literals

import urllib
import urlparse

import werkzeug.datastructures

from mpfs.common.util.strings import smart_str

text_type = unicode


def _iter_multi_items(mapping):
    """Генератор для отображения, возвращающий пары (ключ, значение)."""
    if isinstance(mapping, werkzeug.datastructures.MultiDict):
        for item in mapping.items(multi=True):
            yield item
    elif isinstance(mapping, dict):
        for key, value in mapping.items():
            if isinstance(value, (tuple, list)):
                for v in value:
                    yield key, v
            else:
                yield key, value
    else:
        for item in mapping:
            yield item


def _urlencode_impl(query, encoding='utf-8'):
    iterable = _iter_multi_items(query)
    for key, value in iterable:
        if value is None:
            continue
        if not isinstance(key, bytes):
            key = text_type(key).encode(encoding)
        if not isinstance(value, bytes):
            value = text_type(value).encode(encoding)
        yield quote(key) + '=' + quote(value)


def urlencode(query, encoding='utf-8'):
    """Превращает объект отображения или последовательность
    двухэлементных кортежей в “percent-encoded” строку.

    Если у ключа несколько значений, то они все войдут в результирующую строку.
    """
    separator = b'&'
    return separator.join(_urlencode_impl(query=query, encoding=encoding))


def update_qs_params(url, params):
    """Изменить GET-параметры в URL `url` на параметры из `params`."""
    parsed_url = urlparse.urlparse(url)
    ascii_encoded_query = parsed_url.query.encode('ASCII')  # in case we have unicode values
    # https://stackoverflow.com/questions/16614695/python-urlparse-parse-qs-unicode-url

    qs_params = urlparse.parse_qs(ascii_encoded_query, keep_blank_values=True)

    qs_params.update(params)

    parsed_url = list(parsed_url)
    # верстка не воспринимает `+` в строке запроса
    parsed_url[4] = urllib.urlencode(qs_params, doseq=True).replace('+', '%20')

    return urlparse.urlunparse(parsed_url)


def quote(v, safe=''):
    """
    Кодирует значения в URL-encoded формат. Всегда возвращает str.

    Портированный mpfs.platform.utils.quote
    :rtype: str
    """
    ret = repr(v)
    if isinstance(v, (bytes, str, unicode)):
        ret = smart_str(v)
    ret = urllib.quote(ret, safe=safe)
    return ret


def unquote(v):
    """
    Декодирует URL-encoded значение. Всегда возвращает unicode.

    Портированный mpfs.platform.utils.unquote
    :rtype: unicode
    """
    ret = v
    if isinstance(v, str):
        ret = ret.decode('utf-8')
    ret = ret.encode('utf-8')
    ret = urllib.unquote(ret)
    ret = ret.decode('utf-8')
    return ret
