# coding: utf-8
from mpfs.config import settings

RKUB = ['RU', 'UA', 'BY', 'KZ', None]  # пользователей у которых страна неизвестна относим к РКУБ в данном эксперименте
COUNTRY_KEY = '/country'
COUNTRY_FIELD = 'country'


def is_enabled_users_experiment(experiments, flag, testid):
    result = False
    for experiment in experiments:
        try:
            if (flag in experiment['CONTEXT']['DISK']['flags']) and (testid in experiment['CONTEXT']['DISK']['testid']):
                result = True
                break
        except:
            pass
    return result


def filter_users_experiment(experiments, testids):
    result = []

    for experiment in experiments:
        try:
            if testids & set(experiment['CONTEXT']['DISK']['testid']):
                continue
        except:
            pass
        result.append(experiment)
    return result


def get_user_country(uid):
    from mpfs.core.metastorage.control import disk_info
    from mpfs.core.services.passport_service import passport
    country_info = disk_info.find_one_by_field(uid, {'key': COUNTRY_KEY})
    if country_info:
        country = country_info['data'][COUNTRY_FIELD]
    else:
        country = passport.userinfo(uid).get('country')
    return country.upper() if country else None


def user_unlim_experiment_data(uid, is_rkub_experiment=None):
    """
    Метод для определения попал ли пользователь в эксперимент по отключению видеобезлимита
    :param str uid:
    :param bool is_rkub_experiment:
    :return: попал ли пользователь в эксперимент
    :rtype: (bool, bool)
    """
    is_rkub = get_user_country(uid) in RKUB
    return True, is_rkub
