# -*- coding: utf-8 -*-
import re


class YcridPlatformPrefix(object):
    REST = 'rest'
    DAV = 'dav'
    REST_IOS = 'rest_ios'
    REST_ANDR = 'rest_andr'
    WEB = 'web'


class YcridParser(object):
    ios_ycrid_regex = re.compile('^(rest_ios-|ios-).*$')
    andr_ycrid_regex = re.compile('^(rest_andr-|andr-).*$')

    @classmethod
    def get_platform(cls, ycrid):
        """Возвращает платформу (префикс)"""
        if not ycrid:
            return None
        return ycrid.split('-', 1)[0]

    @classmethod
    def is_yandex_disk_mobile(cls, ycrid):
        """Возвращает True для мобильных клиентов Яндекс.Диска"""
        if not ycrid:
            return False
        return bool(cls.ios_ycrid_regex.match(ycrid) or cls.andr_ycrid_regex.match(ycrid))
