# -*- coding: utf-8 -*-
import pprint

from mpfs.config.errors import ConfigError
from mpfs.config import constants

__all__ = ['Settings', 'settings']


class Settings(object):
    """
    Класс настроек

    Доступ ко всем настройкам и константам осуществляется через него(через его атрибуты).
    Константы - атрибуты захардкоженные в этом классе. Админы не могут их менять.
    Настройки - атрибуты установленные этому классу извне. Могут изменяться админами.
    """

    def __init__(self, config):
        if not isinstance(config, dict):
            raise ConfigError()
        for k, v in config.iteritems():
            if hasattr(self, k):
                raise ConfigError('Attemp to override constant: "%s"' % k)
            if k.startswith('_'):
                raise ConfigError('Setting "%s" should not starts with "_".' % k)
            setattr(self, k, v)
        from mpfs.config.provider import MPFSWorkingEnvironmentConfigProvider
        # Окружение. Не использовать в бизнес логике приложения.
        self._environment = MPFSWorkingEnvironmentConfigProvider().load_as_dict()

    def __str__(self):
        return str(dict(self._settings().items() + self._constants().items()))

    def __repr__(self):
        return "%s\n%s" % (self.__class__, pprint.pformat(self._settings()))

    def _constants(self):
        return {i: getattr(self.__class__, i) for i in vars(self.__class__) if not i.startswith('_')}

    def _settings(self):
        return vars(self)

    def as_dict(self):
        return self._settings()

    def get_environment(self):
        """Возвратить окружение.

        По сути это содержимое файла /etc/yandex/environment.type.
        """
        return self._environment.get('ENVIRONMENT')

    address = {
        'bad_names': ['..', '.'],
        'max_name_length': 255,
        'max_path_length': 32760,
    }
    X_YANDEX_SALT = '76336c7a96b13f0258054d239e70fec8'
    X_YANDEX_LABEL = 'yadisk'
    """Суперконстанты для Яндекс-заголовка"""


from mpfs.config.builder import mpfs_config_builder
settings = Settings(mpfs_config_builder())
