# -*- coding: utf-8 -*-
from mpfs.common.util import straighten_dictionary
from mpfs.config.errors import ValidationConfigError


class Config(dict):
    def patch(self, patch_obj, allow_new=False):
        """
        Наложить патч на кофиг.

        Если переопределяемое значение существует, то проверяется соответствие типов и перезаписывается.
        Иначе добавляется при``allow_new`` равном True.

        Меняются только конечные значения(list, str, bool) - полностью переписать dict нельзя
        Ограничения:
            * Типы значений должны совпадать у базового конфига и патча

        .. doctest::
            >>> config = Config({'a1': 'b1'})
            >>> config.patch({'a1': 1})
            Traceback (most recent call last):
             ...
            ValidationConfigError: Patch_obj "a1" value has wrong type. Expected: "<type 'str'>". Got: "<type 'dict'>".. Config bad path: "ROOT->a1"
            >>> config.patch({'a2': 1.0}, allow_new=True)
            >>> assert config == {'a1': 'b1', 'a2': 1.0}
            True
        """
        if not isinstance(patch_obj, dict):
            raise ValidationConfigError('Patch_obj should be dict. Got: "%s".' % type(patch_obj))

        for key, value in patch_obj.iteritems():
            try:
                if key not in self:
                    if allow_new:
                        self[key] = value
                    else:
                        raise ValidationConfigError('No such key in config: "%s"' % key)

                if (value is None and isinstance(self[key], (int, float, basestring)) or
                        self[key] is None and isinstance(value, (int, float, basestring))):
                    # None можно заменять на простой тип и наоборот
                    self[key] = value
                elif isinstance(value, dict) and isinstance(self[key], dict):
                    self[key] = Config(self[key])
                    self[key].patch(value, allow_new)
                elif isinstance(value, basestring) and isinstance(self[key], basestring):
                    # Подтипы basestring можно заменять друг на друга
                    self[key] = value
                elif type(self[key]) is not type(value):
                    msg = 'Patch_obj "%s" value has wrong type. Expected: "%s". Got: "%s".' % (key, type(self[key]), type(value))
                    raise ValidationConfigError(msg)
                else:
                    self[key] = value
            except ValidationConfigError as e:
                e.keys_stack.append(key)
                raise

    def get_straighten_paths(self, prefix=None, delimeter='_', fake_delimeter=' '):
        """
        Создание отображения переменная - путь в конфиге

        Формируется словарь вида:
        {
            'prefix_service_name': 'service name',
            'prefix_service_name_2: 'service name 2',
        }
        """
        result = {}
        for k, v in straighten_dictionary(self, delimeter=fake_delimeter).iteritems():
            env_name = k.replace(fake_delimeter, delimeter)
            if prefix:
                env_name = "%s%s" % (prefix, env_name)
            result[env_name.lower()] = "%s%s%s" % (k, fake_delimeter, type(v).__name__)
        return result

