# -*- coding: utf-8 -*-

import os

# ПУТИ ДО КОНФИГОВ
## Рутовый путь mpfs-ых настроек
MPFS_CONFIG_ROOT = os.path.normpath(os.environ.get('MPFS_CONFIG_PATH') or '/etc/yandex/mpfs')
## путь до глобальных настроек
GLOBAL_SETTINGS_PATH = '%s/global_settings.yaml' % MPFS_CONFIG_ROOT
## шаблон путей до переопределяющих конфигов
ENV_OVERRIDES_PATH_TEMPLATE = MPFS_CONFIG_ROOT + '/overrides/%(ENVIRONMENT)s.common.yaml'
ENV_PKG_OVERRIDES_PATH_TEMPLATE = MPFS_CONFIG_ROOT + '/overrides/%(ENVIRONMENT)s.%(PACKAGE)s.yaml'
## путь до админского переопределяющего конфига
ADMINS_OVERRIDES_PATH = '%s/admins_overrides.yaml' % MPFS_CONFIG_ROOT
## путь до файла с ключами - аналог admin_overrides, но для ключей
ACCESS_OVERRIDES_PATH = '%s/access_overrides.yaml' % MPFS_CONFIG_ROOT
## путь до файла с uid для эксперемента с `disk_android_videounlim_alert`
DISK_ANDROID_VIDEOUNLIM_ALERT_FILE_PATH = "%s/disk_android_videounlim_alert.uids" % MPFS_CONFIG_ROOT
## путь до файла с секретами (ключами для других сервисов и прочим)
SECRET_KEYS_SETTINGS_PATH = '/etc/yandex/disk-secret-keys.yaml'

# ВОЗМОЖНЫЕ ЗНАЧЕНИЯ
## разрешенные значения окружения
ALLOWED_ENVIRONMENTS = ('development', 'testing', 'prestable', 'production')
## разрешенные значения пакетов
ALLOWED_PACKAGES = ('disk', 'browser', 'platform')

# ПЕРЕМЕННЫЕ ОКРУЖЕНИЯ
## Префикс MPFS-ых настроек для переменных окружения
MPFS_ENVIRONMENT_PREFIX = 'MPFS_'
## Переменная окружения, содержащая значение окружения
MPFS_ENVIRONMENT_VAR = '%sENVIRONMENT' % MPFS_ENVIRONMENT_PREFIX
## Переменная окружения, содержащая имя пакета
MPFS_PACKAGE_VAR = '%sPACKAGE' % MPFS_ENVIRONMENT_PREFIX
## путь до файла, содержащего значение окружения
ENVIRONMENT_FILE_PATH = '/etc/yandex/environment.type'
## путь до файла, содержащего значение пакета
PACKAGE_FILE_PATH = '/etc/yandex/mpfs/package.type'
