# -*- coding: utf-8 -*-


class BaseEnvironmentVariable(object):
    """Класс переменных окружения с приведением к типу"""
    type_cast = None

    def __init__(self, settings=""):
        self.settings = settings

    def cast(self, value):
        return self.type_cast(value)


class StringEnvironmentVariable(BaseEnvironmentVariable):
    type_cast = str


class LowerStringEnvironmentVariable(StringEnvironmentVariable):
    def cast(self, value):
        return value.lower()


class IntEnvironmentVariable(BaseEnvironmentVariable):
    type_cast = int


class FloatEnvironmentVariable(BaseEnvironmentVariable):
    type_cast = float
