# -*- coding: utf-8 -*-


class ConfigError(Exception):
    """Базовый класс ошибок конфигурации"""


class ProviderConfigError(ConfigError):
    """Ошибка поставщика конфига"""


class NoSourceConfigError(ProviderConfigError):
    """Невозможно получить сырые данные"""


class BadFormatConfigError(ProviderConfigError):
    """Неверный формат конфига"""


class ValidationConfigError(ConfigError):
    """Не соответсвие типов при накладывание патча"""
    def __init__(self, *args, **kwargs):
        self.keys_stack = []
        self.config_path = None
        super(ValidationConfigError, self).__init__(*args, **kwargs)

    def __str__(self):
        config_bad_path = '->'.join(['ROOT'] + [str(i) for i in reversed(self.keys_stack)])
        base_msg = '%s. Config bad path: "%s".' % (self.message, config_bad_path)
        if self.config_path is not None:
            base_msg = '%s Check: "%s"' % (base_msg, self.config_path)
        return base_msg
