# -*- coding: utf-8 -*-
import click


@click.command('get_album_by_public_key', help=u"Получить альбом по публичному ключу")
@click.argument('public_key')
@click.option("--items/--no-items", help=u"Заполнить `items`", default=False)
def get_album_by_public_key(public_key, items):
    import mpfs.engine.process
    mpfs.engine.process.setup_anyone_script()
    import mpfs.core.albums.logic.common
    from mpfs.frontend.formatter.disk.json import JSON
    album = mpfs.core.albums.logic.common.get_album_by_public_key(public_key)
    formatter = JSON()
    formatter.request = None
    click.echo(formatter._format_album(album, include_items=items))
