# -*- coding: utf-8 -*-
import click


@click.command('get_public_album', help=u"Получить альбом по публичному ключу и пользователю")
@click.argument('public_key')
@click.argument('req_uid')
@click.option("--items/--no-items", help=u"Заполнить `items`", default=False)
def get_public_album(public_key, req_uid, items):
    import mpfs.engine.process
    mpfs.engine.process.setup_anyone_script()
    import mpfs.core.albums.logic.common
    from mpfs.frontend.formatter.disk.json import JSON
    album = mpfs.core.albums.logic.common.get_public_album(public_key, req_uid)
    formatter = JSON()
    formatter.request = None
    click.echo(formatter._format_album(album, include_items=items))

