# -*- coding: utf-8 -*-

from mpfs.dao.base import BaseDAOItem, BaseDAO, PostgresBaseDAOImplementation
from mpfs.dao.fields import UidField, IntegerField
from mpfs.metastorage.postgres.queries import SQL_INITIALIZE_ALBUMS_REVISION, SQL_GET_ALBUMS_REVISION
from mpfs.metastorage.postgres.schema import albums_info


class AlbumsInfoDAOItem(BaseDAOItem):
    mongo_collection_name = None
    postgres_table_obj = albums_info
    is_sharded = True

    uid = UidField(mongo_path=None, pg_path=albums_info.c.uid)
    revision = IntegerField(mongo_path=None, pg_path=albums_info.c.revision)


class AlbumsInfoDAO(BaseDAO):
    dao_item_cls = AlbumsInfoDAOItem

    def __init__(self):
        super(AlbumsInfoDAO, self).__init__()
        self._pg_impl = PostgresAlbumsInfoDAOImplementation(self.dao_item_cls)

    def create_base_revision(self, uid):
        impl = self._get_impl(uid)
        return impl.create_base_revision(uid)

    def get_revision(self, uid):
        impl = self._get_impl(uid)
        return impl.get_revision(uid)


class PostgresAlbumsInfoDAOImplementation(PostgresBaseDAOImplementation):
    def create_base_revision(self, uid):
        session = self.get_session(uid)
        session.execute(SQL_INITIALIZE_ALBUMS_REVISION, {'uid': uid})

    def get_revision(self, uid):
        session = self.get_session(uid)
        return session.execute(SQL_GET_ALBUMS_REVISION, {'uid': uid}).fetchone()
