# -*- coding: utf-8 -*-
from mpfs.common.errors import MPFSError
from mpfs.common.static import codes


class AlbumsError(MPFSError):
    pass


class AlbumsJsonBodyExpectedError(AlbumsError):
    code = codes.ALBUMS_JSON_BODY_EXPECTED


class AlbumsGETBodyExpectedError(AlbumsError):
    code = codes.ALBUMS_GET_BODY_EXPECTED


class AlbumsTooManyResourcesError(AlbumsError):
    code = codes.ALBUMS_TOO_MANY_RESOURCES


class AlbumsInvalidJSONBodyError(AlbumsError):
    code = codes.ALBUMS_INVALID_JSON_BODY


class AlbumsCoverIndexOutOfRangeError(AlbumsError):
    code = codes.ALBUMS_COVER_INDEX_OUT_OF_RANGE


class AlbumsUnableToUseAlbumAsCoverError(AlbumsError):
    code = codes.ALBUMS_UNABLE_TO_USE_ALBUM_AS_COVER


class AlbumsUnableToUseFolderAsCoverError(AlbumsError):
    code = codes.ALBUMS_UNABLE_TO_USE_FOLDER_AS_COVER


class AlbumsWrongLayoutError(AlbumsError):
    code = codes.ALBUMS_WRONG_LAYOUT


class AlbumsCoverOffsetWrongTypeError(AlbumsError):
    code = codes.ALBUMS_COVER_WRONG_OFFSET_TYPE


class AlbumsIsNotPublicError(AlbumsError):
    code = codes.ALBUMS_IS_NOT_PUBLIC


class AlbumsUnableToPublishUnsavedError(AlbumsError):
    code = codes.ALBUMS_UNABLE_TO_PUBLISH_UNSAVED


class AlbumsUnableToDelete(AlbumsError):
    code = codes.ALBUMS_UNABLE_TO_DELETE


class AlbumsUnableToAppendItem(AlbumsError):
    code = codes.ALBUMS_UNABLE_TO_APPEND_ITEM


class AlbumsPostToSocialFailedError(AlbumsError):
    code = codes.ALBUMS_POST_TO_SOCIAL_FAILED


class AlbumsUpdateSocialCoverError(AlbumsError):
    code = codes.ALBUMS_UPDATE_SOCIAL_COVER_FAILED


class AlbumsProviderNotFound(AlbumsError):
    code = codes.ALBUMS_PROVIDER_NOT_FOUND_ERROR


class AlbumItemMissed(AlbumsError):
    code = codes.ALBUM_ITEM_MISSED


class AlbumsWrongGeneratedType(AlbumsError):
    code = codes.ALBUM_WRONG_GENERATED_TYPE


class AlbumTitleTooLong(AlbumsError):
    code = codes.ALBUM_TITLE_TOO_LONG


class AlbumAlreadyExists(AlbumsError):
    response = 409
    code = codes.ALBUM_ALREADY_EXISTS
    message = 'Album already exists'


class PhotoAlbumNotFoundError(AlbumsError):
    response = 404
    code = codes.ALBUM_NOT_FOUND
    message = 'Album not found'
