# -*- coding: utf-8 -*-
from mpfs.core.event_dispatcher.events import Event


class AlbumEvent(Event):
    """Базовое событие альбомов"""


class AlbumChangeEvent(AlbumEvent):
    """Изменение альбома"""
    required_fields = (('album', object),
                       ('request', object))


class AlbumCreateEvent(AlbumChangeEvent):
    """Создание альбома"""


class AlbumRemoveEvent(AlbumChangeEvent):
    """Удаление альбома"""


class AlbumChangeCoverEvent(AlbumChangeEvent):
    """Изменилась обложка"""


class AlbumChangeCoverOffsetEvent(AlbumChangeEvent):
    """Изменилось вертикальное смещение обложки"""


class AlbumChangePublishEvent(AlbumChangeEvent):
    """Изменилась публичность"""


class AlbumChangeTitleEvent(AlbumChangeEvent):
    """Изменилось название"""
    required_fields = (('prev_title', basestring),)


class AlbumChangeItemsEvent(AlbumChangeEvent):
    """Изменение элементов альбома"""
    required_fields = (('items', list),)


class AlbumChangeItemsAppendEvent(AlbumChangeItemsEvent):
    """Добавились элементы"""


class AlbumChangeItemsRemoveEvent(AlbumChangeItemsEvent):
    """Удалились элементы"""


class AlbumPostToSocialEvent(AlbumEvent):
    """Публикация альбома в соц. сеть"""
    required_fields = (('album', object),
                       ('provider', basestring))
