# -*- coding: utf-8 -*-
import mpfs.engine.process

from mpfs.core.albums.models import Album
from mpfs.core.albums.errors import AlbumsUpdateSocialCoverError
from mpfs.engine.queue2.celery import BaseTask, app


log = mpfs.engine.process.get_default_log()
error_log = mpfs.engine.process.get_error_log()


@app.task(base=BaseTask)
def handle_update_social_cover(uid, album_id, old_social_cover_stid, context=None, **kwargs):
    album = Album.controller.get(uid=uid, id=album_id)
    if album is None:
        log.warning('update_social_cover requested for non-existent album, uid=%s, album.id=%s' % (uid, album_id))
        return
    try:
        album.update_social_cover(old_social_cover_stid=old_social_cover_stid)
    except AlbumsUpdateSocialCoverError as e:
        log.info(str(e))


@app.task(base=BaseTask)
def handle_file_changed_operation(uid, resource_ids, context=None, **kwargs):
    # handled in djfs-albums
    raise NotImplementedError()


@app.task(base=BaseTask)
def handle_start_album_creation(uid, context=None, **kwargs):
    # handled in djfs-albums
    raise NotImplementedError()
