# -*- coding: utf-8 -*-
"""

MPFS
BILLING

Библиотека методов для внутренних нужд

"""
import mpfs.engine.process

from mpfs.config import settings
from mpfs.common.errors import billing as errors
from mpfs.common.static.tags.billing import *
from mpfs.core.billing.client import Client
from mpfs.core.billing.constants import PRODUCT_INITIAL_10GB_ID, DEFAULT_SERVICE_ID
from mpfs.core.billing.product import Product
from mpfs.core.billing.market import Market
from mpfs.core.billing.service import Service, ServiceList
from mpfs.core.billing.product.catalog import Catalog, JOINED_PRODUCTS
from mpfs.core.billing.processing import common

log = mpfs.engine.process.get_default_log()
error_log = mpfs.engine.process.get_error_log()

catalog = Catalog()


def service_create(uid, pid, line, enable=True, attributes=None, send_email=True):
    client = Client(uid)
    product = Product(pid)

    market_code = settings.billing['default_market'] if not client.attributes.market else client.attributes.market
    market = Market(market_code)

    if product.pid not in catalog.get_pids(market, line):
        raise errors.BillingInvalidMarketLineProduct(product.pid)

    return common.simple_create_service(
        client,
        product,
        enable=enable,
        attributes=attributes,
        send_email=send_email,
    )


def service_delete(uid, sid=None, pid=None, disable=True, send_email=True):
    client = Client(uid)

    if sid:
        service = Service(sid)
    elif pid:
        service_list = filter(lambda x: x[PID] == pid, ServiceList(client=client))
        sid = None
        if service_list:
            sid = service_list[0][SID]
        service = Service(sid)
    else:
        service = None

    if (service and
            sid != DEFAULT_SERVICE_ID):
        common.simple_delete_service(client, service, disable=disable, send_email=send_email)


def _temporary_enlarge_space(uid, reason, line=None, space=None):
    pid = JOINED_PRODUCTS.get(reason, reason)
    # Avoid enlargement for users who already has initial 10gb of space.
    # Import here to avoid import loop.
    from mpfs.core.billing.processing import pushthelimits
    if pushthelimits.can_pushto_10gb(uid, pid):
        try:
            service_create(uid, pid, line=line)
        except errors.BillingProductIsSingletone:
            log.warn('%s already has service %s', uid, pid, exc_info=True)


def _temporary_reduce_space(uid, reason, space=None):
    pid = JOINED_PRODUCTS.get(reason, reason)
    service_delete(uid, pid=pid)



