# -*- coding: utf-8 -*-
"""

MPFS
BILLING

Клиент 

"""
import mpfs.engine.process

from mpfs.core.billing.client.attributes import ClientAttributes
from mpfs.common.static.tags.billing import *
from mpfs.core.services.billing_service import BB
from mpfs.core.services.passport_service import Passport

log = mpfs.engine.process.get_default_log()
error_log = mpfs.engine.process.get_error_log()

passport = Passport()


class Client(object):
    def __init__(self, uid, ip=None):
        self.uid = uid
        self.ip = ip if ip else mpfs.engine.process.hostip()
        self.agreements = self.load_agreements()
        self.attributes = self.load_attributes()
        self._payment_methods = None
        self.payment_methods_loaded = False

    def load_agreements(self):
        return [Agreement(self.uid, self.uid)]

    def load_attributes(self):
        return ClientAttributes(self.uid)

    def bind_market(self, market):
        return self.attributes.set(MARKET, market.code)

    def payment_methods(self):
        if not self.payment_methods_loaded:
            from mpfs.core.billing import Market  # циклический импорт
            market = Market(self.attributes.market)
            self._payment_methods = PaymentMethods(self.uid, self.ip, market)
            self.payment_methods_loaded = True
        return self._payment_methods

    def list_payment_methods(self):
        from mpfs.core.billing import Market
        market = Market(self.attributes.market)
        return PaymentMethods(self.uid, self.ip, market, check_with_billing=False).all_applicable()

    def make_undeletable(self):
        try:
            from mpfs.core.user.base import User

            User(self.uid).passport_subscribe_undeletable()
        except Exception:
            error_log.error('failed to subscribe undeletable %s' % self.uid)


class Agreement(object):
    """
    Заглушка на будущее
    """

    def __init__(self, uid, aid):
        self.uid = uid
        self.id = aid


class PaymentMethods(object):
    """
    Способы оплаты 
    """

    def __init__(self, uid, ip, market, check_with_billing=True):
        self.phone = False
        if check_with_billing:
            data = BB.list_payment_methods(uid, ip, region=market.region)
            self.phone = 'phone-1' if 'phone-1' in data else False
        self.inapp = False
        payment_methods = set(market.payment_methods)
        self.bankcard = 'bankcard' in payment_methods
        self.yamoney = 'yamoney' in payment_methods

        passport_info = passport.userinfo(uid)
        if passport_info['pdd']:
            self.yamoney = False

    def is_allowed(self, method):
        return getattr(self, method) is not False

    def get_personal_id(self, method):
        return getattr(self, method)

    def all_applicable(self):
        result = []
        for method in ('phone', 'bankcard', 'inapp', 'yamoney'):
            if getattr(self, method) is not False:
                result.append(method)
        return result