# -*- coding: utf-8 -*-
"""

MPFS
BILLING

Атрибуты пользователя

"""
import mpfs.engine.process

log = mpfs.engine.process.get_default_log()
error_log = mpfs.engine.process.get_error_log()

from mpfs.common.static.tags.billing import *
from mpfs.core.billing.entity import Entity

class ClientAttributes(Entity):
    
    namespace = 'billing'
        
    def __init__(self, uid):
        from mpfs.core.user.base import User
        self.user = User(uid)

        if self.user.is_standart:
            self._data = self.user.states.list(namespace=self.namespace)
        else:
            self._data = {}
        
    def set(self, key, value):
        self.user.states.set(key, value, namespace=self.namespace)
        super(ClientAttributes, self).set(key, value)
                  
    def remove(self, key):
        self.user.states.remove(key, namespace=self.namespace)
        super(ClientAttributes, self).remove(key)

    
    
    
    