# -*- coding: utf-8 -*-
from mpfs.config import settings
from mpfs.dao.base import (
    BaseDAO,
    BaseDAOItem,
)
from mpfs.dao.fields import (
    StringField,
    IntegerField,
)

from mpfs.metastorage.postgres.schema import billing_locks


class BillingLocksDAOItem(BaseDAOItem):
    mongo_collection_name = 'billing_locks'
    postgres_table_obj = billing_locks
    is_sharded = False

    @classmethod
    def get_postgres_primary_key(cls):
        return 'id'

    id = StringField(mongo_path='_id', pg_path=billing_locks.c.id)
    host = StringField(mongo_path='host', pg_path=billing_locks.c.host, default_value=None)
    lock = IntegerField(mongo_path='lock', pg_path=billing_locks.c.lock, default_value=None)


class BillingLocksDAO(BaseDAO):
    dao_item_cls = BillingLocksDAOItem
