# -*- coding: utf-8 -*-
from mpfs.config import settings
from mpfs.dao.base import (
    BaseDAO,
    BaseDAOItem,
)
from mpfs.dao.fields import (
    BoolField,
    StringField,
    IntegerField,
    DateTimeField,
    UidField,
    UuidField,
    UidArrayField,
)

from mpfs.metastorage.postgres.schema import billing_orders


class BillingOrdersDAOItem(BaseDAOItem):
    mongo_collection_name = 'billing_orders'
    postgres_table_obj = billing_orders
    is_sharded = False

    @classmethod
    def get_postgres_primary_key(cls):
        return 'id'

    id = StringField(mongo_path='_id', pg_path=billing_orders.c.id)
    auto = BoolField(mongo_path='auto', pg_path=billing_orders.c.auto, default_value=None)
    bb_pid = StringField(mongo_path='bb_pid', pg_path=billing_orders.c.bb_pid, default_value=None)
    ctime = DateTimeField(mongo_path='ctime', pg_path=billing_orders.c.ctime, default_value=None)
    currency = StringField(mongo_path='currency', pg_path=billing_orders.c.currency, default_value=None)
    discount_template_id = UuidField(mongo_path='discount_template_id',
                                     pg_path=billing_orders.c.discount_template_id, default_value=None)
    group_name = StringField(mongo_path='group_name', pg_path=billing_orders.c.group_name, default_value=None)
    group_uids = UidArrayField(mongo_path='group_uids', pg_path=billing_orders.c.group_uids, default_value=None)
    locale = StringField(mongo_path='locale', pg_path=billing_orders.c.locale, default_value=None)
    market = StringField(mongo_path='market', pg_path=billing_orders.c.market, default_value=None)
    mtime = DateTimeField(mongo_path='mtime', pg_path=billing_orders.c.mtime, default_value=None)
    otype = StringField(mongo_path='otype', pg_path=billing_orders.c.otype, default_value=None)
    payment_id = StringField(mongo_path='payment_id', pg_path=billing_orders.c.payment_id, default_value=None)
    payment_method = StringField(mongo_path='payment_method', pg_path=billing_orders.c.payment_method,
                                 default_value=None)
    pid = StringField(mongo_path='pid', pg_path=billing_orders.c.pid, default_value=None)
    price = IntegerField(mongo_path='price', pg_path=billing_orders.c.price, default_value=None)
    sid = StringField(mongo_path='sid', pg_path=billing_orders.c.sid, default_value=None)
    state = StringField(mongo_path='state', pg_path=billing_orders.c.state, default_value=None)
    uid = UidField(mongo_path='uid', pg_path=billing_orders.c.uid)
    v = IntegerField(mongo_path='v', pg_path=billing_orders.c.v)


class BillingOrdersDAO(BaseDAO):
    dao_item_cls = BillingOrdersDAOItem
