# -*- coding: utf-8 -*-
from bson import ObjectId

from mpfs.dao.base import (
    BaseDAO,
    BaseDAOItem,
    PostgresBaseDAOImplementation,
)
from mpfs.dao.fields import (
    BoolField,
    DateTimeField,
    IntegerField,
    ObjectIdField,
    StringField,
    UidField,
    UuidField,
)

from mpfs.metastorage.postgres.schema import billing_orders_history


class BillingOrdersHistoryDAOItem(BaseDAOItem):
    mongo_collection_name = 'billing_orders_history'
    postgres_table_obj = billing_orders_history
    is_sharded = False

    @classmethod
    def get_postgres_primary_key(cls):
        return 'id'

    id = ObjectIdField(mongo_path='_id', pg_path=billing_orders_history.c.id)
    moved = BoolField(mongo_path='_moved', pg_path=billing_orders_history.c.moved, default_value=None)
    auto = BoolField(mongo_path='auto', pg_path=billing_orders_history.c.auto, default_value=None)
    bb_pid = StringField(mongo_path='bb_pid', pg_path=billing_orders_history.c.bb_pid, default_value=None)
    ctime = DateTimeField(mongo_path='ctime', pg_path=billing_orders_history.c.ctime, default_value=None)
    currency = StringField(mongo_path='currency', pg_path=billing_orders_history.c.currency, default_value=None)
    description = StringField(mongo_path='description', pg_path=billing_orders_history.c.description,
                              default_value=None)
    discount_template_id = UuidField(mongo_path='discount_template_id',
                                     pg_path=billing_orders_history.c.discount_template_id, default_value=None)
    fuckup_period = StringField(mongo_path='fuckup_period', pg_path=billing_orders_history.c.fuckup_period,
                                default_value=None)
    locale = StringField(mongo_path='locale', pg_path=billing_orders_history.c.locale, default_value=None)
    market = StringField(mongo_path='market', pg_path=billing_orders_history.c.market, default_value=None)
    mtime = DateTimeField(mongo_path='mtime', pg_path=billing_orders_history.c.mtime, default_value=None)
    number = StringField(mongo_path='number', pg_path=billing_orders_history.c.number, default_value=None)
    otype = StringField(mongo_path='otype', pg_path=billing_orders_history.c.otype, default_value=None)
    payment_id = StringField(mongo_path='payment_id', pg_path=billing_orders_history.c.payment_id, default_value=None)
    payment_method = StringField(mongo_path='payment_method', pg_path=billing_orders_history.c.payment_method,
                                 default_value=None)
    pid = StringField(mongo_path='pid', pg_path=billing_orders_history.c.pid, default_value=None)
    price = IntegerField(mongo_path='price', pg_path=billing_orders_history.c.price, default_value=None)
    receipt = StringField(mongo_path='receipt', pg_path=billing_orders_history.c.receipt, default_value=None)
    refund_status = StringField(mongo_path='refund_status', pg_path=billing_orders_history.c.refund_status,
                                default_value=None)
    sid = StringField(mongo_path='sid', pg_path=billing_orders_history.c.sid, default_value=None)
    state = StringField(mongo_path='state', pg_path=billing_orders_history.c.state, default_value=None)
    status_code = StringField(mongo_path='status_code', pg_path=billing_orders_history.c.status_code,
                              default_value=None)
    trust_refund_id = StringField(mongo_path='trust_refund_id', pg_path=billing_orders_history.c.trust_refund_id,
                                  default_value=None)
    uid = UidField(mongo_path='uid', pg_path=billing_orders_history.c.uid)
    v = IntegerField(mongo_path='v', pg_path=billing_orders_history.c.v)


class BillingOrdersHistoryDAO(BaseDAO):
    dao_item_cls = BillingOrdersHistoryDAOItem

    def __init__(self):
        super(BillingOrdersHistoryDAO, self).__init__()
        self._pg_impl = PostgresBillingOrdersHistoryDAOImplementation(self.dao_item_cls)

    def insert(self, doc_or_docs, manipulate=True, continue_on_error=False, **kwargs):
        if isinstance(doc_or_docs, list):
            for doc in doc_or_docs:
                if '_id' not in doc:
                    doc['_id'] = ObjectId()
        else:
            if '_id' not in doc_or_docs:
                doc_or_docs['_id'] = ObjectId()

        return super(BillingOrdersHistoryDAO, self).insert(doc_or_docs, manipulate, continue_on_error, **kwargs)


class PostgresBillingOrdersHistoryDAOImplementation(PostgresBaseDAOImplementation):
    def insert(self, doc_or_docs, manipulate=True, continue_on_error=False, **kwargs):
        if isinstance(doc_or_docs, list):
            for doc in doc_or_docs:
                # Преобразовываем старые текстовые _id в ObjectId при миграции
                if '_id' not in doc or not ObjectId.is_valid(str(doc['_id'])):
                    doc['_id'] = ObjectId()
        else:
            if '_id' not in doc_or_docs:
                doc_or_docs['_id'] = ObjectId()

        return super(PostgresBillingOrdersHistoryDAOImplementation, self).insert(
            doc_or_docs, manipulate, continue_on_error, **kwargs)
