# -*- coding: utf-8 -*-
from mpfs.config import settings
from mpfs.dao.base import (
    BaseDAO,
    BaseDAOItem,
)
from mpfs.dao.fields import (
    IntegerField,
    UidField,
    UuidField)

from mpfs.metastorage.postgres.schema import billing_service_attributes_history


class BillingServiceAttributesHistoryDAOItem(BaseDAOItem):
    mongo_collection_name = 'billing_service_attributes_history'
    postgres_table_obj = billing_service_attributes_history
    is_sharded = False

    @classmethod
    def get_postgres_primary_key(cls):
        return 'id'

    id = UuidField(mongo_path='_id', pg_path=billing_service_attributes_history.c.id)
    amount = IntegerField(mongo_path='amount', pg_path=billing_service_attributes_history.c.amount, default_value=None)
    uid = UidField(mongo_path='uid', pg_path=billing_service_attributes_history.c.uid, default_value=None)
    v = IntegerField(mongo_path='v', pg_path=billing_service_attributes_history.c.v)


class BillingServiceAttributesHistoryDAO(BaseDAO):
    dao_item_cls = BillingServiceAttributesHistoryDAOItem
