# -*- coding: utf-8 -*-
from mpfs.config import settings
from mpfs.dao.base import (
    BaseDAO,
    BaseDAOItem,
)
from mpfs.dao.fields import (
    BoolField,
    StringField,
    IntegerField,
    DateTimeField,
    UidField,
    StringArrayField,
    UidArrayField,
)

from mpfs.metastorage.postgres.schema import billing_services


class BillingServicesDAOItem(BaseDAOItem):
    mongo_collection_name = 'billing_services'
    postgres_table_obj = billing_services
    is_sharded = False

    @classmethod
    def get_postgres_primary_key(cls):
        return 'id'

    id = StringField(mongo_path='_id', pg_path=billing_services.c.id)
    moved = BoolField(mongo_path='_moved', pg_path=billing_services.c.moved, default_value=None)
    auto = BoolField(mongo_path='auto', pg_path=billing_services.c.auto, default_value=None)
    btime = DateTimeField(mongo_path='btime', pg_path=billing_services.c.btime, default_value=None)
    buyer_uid = UidField(mongo_path='buyer_uid', pg_path=billing_services.c.buyer_uid, default_value=None)
    child_sids = StringArrayField(mongo_path='child_sids', pg_path=billing_services.c.child_sids, default_value=None)
    ctime = DateTimeField(mongo_path='ctime', pg_path=billing_services.c.ctime, default_value=None)
    description = StringField(mongo_path='description', pg_path=billing_services.c.description, default_value=None)
    dtime = DateTimeField(mongo_path='dtime', pg_path=billing_services.c.dtime, default_value=None)
    enabled = BoolField(mongo_path='enabled', pg_path=billing_services.c.enabled, default_value=None)
    first_prolongation_fail = IntegerField(mongo_path='first_prolongation_fail', default_value=None,
                                           pg_path=billing_services.c.first_prolongation_fail)
    group_uids = UidArrayField(mongo_path='group_uids', pg_path=billing_services.c.group_uids, default_value=None)
    group_name = StringField(mongo_path='group_name', pg_path=billing_services.c.group_name, default_value=None)
    is_group = BoolField(mongo_path='group', pg_path=billing_services.c.is_group, default_value=None)
    lbtime = DateTimeField(mongo_path='lbtime', pg_path=billing_services.c.lbtime, default_value=None)
    mtime = DateTimeField(mongo_path='mtime', pg_path=billing_services.c.mtime, default_value=None)
    notified = IntegerField(mongo_path='notified', pg_path=billing_services.c.notified, default_value=None)
    number = StringField(mongo_path='number', pg_path=billing_services.c.number, default_value=None)
    order_id = StringField(mongo_path='order', pg_path=billing_services.c.order_id, default_value=None)
    original_transaction_id = IntegerField(mongo_path='original_transaction_id', default_value=None,
                                          pg_path=billing_services.c.original_transaction_id)
    paid_for_other = BoolField(mongo_path='paid_for_other', pg_path=billing_services.c.paid_for_other,
                               default_value=None)
    parent_sid = StringField(mongo_path='parent_sid', pg_path=billing_services.c.parent_sid, default_value=None)
    pid = StringField(mongo_path='pid', pg_path=billing_services.c.pid, default_value=None)
    state = StringField(mongo_path='state', pg_path=billing_services.c.state, default_value=None)
    uid = UidField(mongo_path='uid', pg_path=billing_services.c.uid)
    v = IntegerField(mongo_path='v', pg_path=billing_services.c.v)


class BillingServicesDAO(BaseDAO):
    dao_item_cls = BillingServicesDAOItem
