# -*- coding: utf-8 -*-
from bson import ObjectId

from mpfs.dao.base import (
    BaseDAO,
    BaseDAOItem,
)
from mpfs.dao.fields import (
    BoolField,
    DateTimeField,
    IntegerField,
    ObjectIdField,
    StringArrayField,
    StringField,
    UidArrayField,
    UidField,
)

from mpfs.metastorage.postgres.schema import billing_services_history


class BillingServicesHistoryDAOItem(BaseDAOItem):
    mongo_collection_name = 'billing_services_history'
    postgres_table_obj = billing_services_history
    is_sharded = False

    @classmethod
    def get_postgres_primary_key(cls):
        return 'id'

    id = ObjectIdField(mongo_path='_id', pg_path=billing_services_history.c.id, default_value=None)
    moved = BoolField(mongo_path='_moved', pg_path=billing_services_history.c.moved, default_value=None)
    auto = BoolField(mongo_path='auto', pg_path=billing_services_history.c.auto, default_value=None)
    btime = DateTimeField(mongo_path='btime', pg_path=billing_services_history.c.btime, default_value=None)
    buyer_uid = UidField(mongo_path='buyer_uid', pg_path=billing_services_history.c.buyer_uid, default_value=None)
    child_sids = StringArrayField(mongo_path='child_sids', pg_path=billing_services_history.c.child_sids, default_value=None)
    ctime = DateTimeField(mongo_path='ctime', pg_path=billing_services_history.c.ctime, default_value=None)
    description = StringField(mongo_path='description', pg_path=billing_services_history.c.description,
                              default_value=None)
    dtime = DateTimeField(mongo_path='dtime', pg_path=billing_services_history.c.dtime, default_value=None)
    enabled = BoolField(mongo_path='enabled', pg_path=billing_services_history.c.enabled, default_value=None)
    first_prolongation_fail = IntegerField(mongo_path='first_prolongation_fail', default_value=None,
                                           pg_path=billing_services_history.c.first_prolongation_fail)
    free = BoolField(mongo_path='free', pg_path=billing_services_history.c.free, default_value=None)
    is_group = BoolField(mongo_path='group', pg_path=billing_services_history.c.is_group, default_value=None)
    group_name = StringField(mongo_path='group_name', pg_path=billing_services_history.c.group_name, default_value=None)
    group_uids = UidArrayField(mongo_path='group_uids', pg_path=billing_services_history.c.group_uids,
                               default_value=None)
    lbtime = DateTimeField(mongo_path='lbtime', pg_path=billing_services_history.c.lbtime, default_value=None)
    mtime = DateTimeField(mongo_path='mtime', pg_path=billing_services_history.c.mtime, default_value=None)
    notified = IntegerField(mongo_path='notified', pg_path=billing_services_history.c.notified, default_value=None)
    number = StringField(mongo_path='number', pg_path=billing_services_history.c.number, default_value=None)
    order_id = StringField(mongo_path='order', pg_path=billing_services_history.c.order_id, default_value=None)
    original_transaction_id = IntegerField(mongo_path='original_transaction_id', default_value=None,
                                          pg_path=billing_services_history.c.original_transaction_id)
    paid_for_other = BoolField(mongo_path='paid_for_other', pg_path=billing_services_history.c.paid_for_other,
                               default_value=None)
    parent_sid = StringField(mongo_path='parent_sid', pg_path=billing_services_history.c.parent_sid, default_value=None)
    pid = StringField(mongo_path='pid', pg_path=billing_services_history.c.pid, default_value=None)
    refund_status = StringField(mongo_path='refund_status', pg_path=billing_services_history.c.refund_status,
                                default_value=None)
    sid = StringField(mongo_path='sid', pg_path=billing_services_history.c.sid, default_value=None)
    state = StringField(mongo_path='state', pg_path=billing_services_history.c.state, default_value=None)
    uid = UidField(mongo_path='uid', pg_path=billing_services_history.c.uid)
    v = IntegerField(mongo_path='v', pg_path=billing_services_history.c.v)


class BillingServicesHistoryDAO(BaseDAO):
    dao_item_cls = BillingServicesHistoryDAOItem

    def insert(self, doc_or_docs, manipulate=True, continue_on_error=False, **kwargs):
        if isinstance(doc_or_docs, list):
            for doc in doc_or_docs:
                if '_id' not in doc:
                    doc['_id'] = ObjectId()
        else:
            if '_id' not in doc_or_docs:
                doc_or_docs['_id'] = ObjectId()

        return super(BillingServicesHistoryDAO, self).insert(doc_or_docs, manipulate, continue_on_error, **kwargs)
