# -*- coding: utf-8 -*-
from mpfs.config import settings
from mpfs.dao.base import (
    BaseDAO,
    BaseDAOItem,
)
from mpfs.dao.fields import (
    StringField,
    IntegerField,
    DateTimeField,
    UidField,
)

from mpfs.metastorage.postgres.schema import billing_subscriptions


class BillingSubscriptionsDAOItem(BaseDAOItem):
    mongo_collection_name = 'billing_subscriptions'
    postgres_table_obj = billing_subscriptions
    is_sharded = False

    @classmethod
    def get_postgres_primary_key(cls):
        return 'id'

    id = StringField(mongo_path='_id', pg_path=billing_subscriptions.c.id)
    ctime = DateTimeField(mongo_path='ctime', pg_path=billing_subscriptions.c.ctime, default_value=None)
    description = StringField(mongo_path='description', pg_path=billing_subscriptions.c.description, default_value=None)
    sid = StringField(mongo_path='sid', pg_path=billing_subscriptions.c.sid, default_value=None)
    uid = UidField(mongo_path='uid', pg_path=billing_subscriptions.c.uid, default_value=None)
    v = IntegerField(mongo_path='v', pg_path=billing_subscriptions.c.v, default_value=None)


class BillingSubscriptionsDAO(BaseDAO):
    dao_item_cls = BillingSubscriptionsDAOItem
