# -*- coding: utf-8 -*-
from types import NoneType

from mpfs.core.event_dispatcher.events import Event
from mpfs.core.billing.product import Product


class BillingEvent(Event):
    """Базовый класс событий оплаты"""
    required_fields = (('uid', basestring),
                       ('product', Product),
                       ('price', (int, float, basestring)),
                       ('currency', basestring),
                       ('auto', bool),)


class BillingPaymentEvent(BillingEvent):
    """Базовый класс событий оплаты"""
    required_fields = (('status', basestring),
                       ('status_code', (basestring, NoneType)),)


class BillingOrderNewEvent(BillingEvent):
    """Событие создания нового заказа"""


class BillingBuyNewEvent(BillingPaymentEvent):
    """Событие оплаты нового заказа"""


class BillingProlongEvent(BillingPaymentEvent):
    """Событие продления услуги"""


class BillingUnsubscribeEvent(BillingEvent):
    """Событий отказа от подписки"""


class BillingDeleteEvent(BillingEvent):
    """Событие удаления услуги"""
