# -*- coding: utf-8 -*-
from types import NoneType
from mpfs.core.billing import InAppProductsHolder
from mpfs.core.metastorage.control import billing_services


class ServiceInAppDAO(object):
    """
    Методы получения in-app услуг из базы

    Сделан, чтобы не пробраcывать in-app-ые запросы через весь наш биллинговый стек
    """

    @staticmethod
    def get_raw_services(btime_lower_bound=None, btime_upper_bound=None, states=None):
        if not isinstance(states, (NoneType, list, tuple)):
            raise TypeError("'states' field must be list. Got: %s" % states)

        query = {
            'original_transaction_id': {'$ne': None},  # mongo don't use index for '$exists'
            'pid': {'$in': list(InAppProductsHolder.all_pids)}
        }
        if states:
            query['state'] = {'$in': list(states)}
        if btime_lower_bound or btime_upper_bound:
            query['btime'] = {}
            if btime_lower_bound:
                query['btime']['$gte'] = int(btime_lower_bound)
            if btime_upper_bound:
                query['btime']['$lte'] = int(btime_upper_bound)

        return list(billing_services.find(query))

    @classmethod
    def get_google_play_raw_services_for_uid(cls, uid):
        return cls._get_raw_services_for_uid(uid, InAppProductsHolder.google_play_pids)

    @classmethod
    def get_apple_appstore_raw_services_for_uid(cls, uid):
        return cls._get_raw_services_for_uid(uid, InAppProductsHolder.apple_appstore_pids)

    @staticmethod
    def _get_raw_services_for_uid(uid, pids):
        if not pids:
            return []
        query = {
            'uid': uid,
            'original_transaction_id': {'$ne': None},  # mongo don't use index for '$exists'
            'pid': {'$in': list(pids)}
        }
        return list(billing_services.find(query))
