# -*- coding: utf-8 -*-
import uuid

from mpfs.common.util import ctimestamp
from mpfs.core.billing.inapp.dao.unprocessed_receipt import UnprocessedReceiptDAO, UnprocessedReceiptDAOItem


class UnprocessedReceipt(object):
    dao = UnprocessedReceiptDAO()
    dao_item_class = UnprocessedReceiptDAOItem

    def __init__(self, dao_item):
        if not isinstance(dao_item, self.dao_item_class):
            raise TypeError("`%s` expected. Got: %r" % (self.dao_item_class.__name__, dao_item))
        self.dao_item = dao_item

    @classmethod
    def build_by_dict(cls, doc):
        dao_item = cls.dao_item_class.create_from_mongo_dict(doc)
        return UnprocessedReceipt(dao_item)

    @property
    def id(self):
        return self.dao_item.id

    def save(self):
        self.dao.save(self.dao_item)


def save_failed_receipt_to_db(uid, str_trace_back, receipt):
    unprocessed_receipt_doc = {
        "_id": uuid.uuid4().hex,
        "uid": uid,
        "syncronization_datetime": ctimestamp(),
        "receipt": receipt,
        "traceback": str_trace_back,
    }
    unprocessed_receipt = UnprocessedReceipt.build_by_dict(unprocessed_receipt_doc)
    unprocessed_receipt.save()
