# -*- coding: utf-8 -*-
"""

MPFS
BILLING

Интерфейс по работе с данными клиента

"""
import mpfs.engine.process

from mpfs.common.errors import billing as errors
from mpfs.config import settings
from mpfs.core.billing.client import Client
from mpfs.core.billing.market import Market
from mpfs.core.services.passport_service import passport

log = mpfs.engine.process.get_default_log()
error_log = mpfs.engine.process.get_error_log()

USER_DEFAULT_COUNTRY = settings.user['default_country']

    
def client_bind_market(req):
    """
    Приписать клиента на определенный рынок
    """
    if req.market is None:
        userinfo = passport.userinfo(req.uid)
        country = userinfo.get('country', USER_DEFAULT_COUNTRY)
        market = Market.from_country(country)
    else:
        market = Market(req.market)
    Client(req.uid, req.ip).bind_market(market)

    
def client_list_attributes(req):
    return Client(req.uid, req.ip).attributes.dict()
    
    
def client_set_attribute(req):
    return Client(req.uid, req.ip).attributes.set(req.attr, req.value)
    
    
def client_remove_attribute(req):
    return Client(req.uid, req.ip).attributes.remove(req.attr)
        

def client_list_payment_methods(req):
    """
    Выдать список возможных способов оплат для рынка клиента
    """
    client = Client(req.uid, req.ip)
    
    if not client.attributes.market:
        raise errors.BillingClientNotBindedToMarket(req.uid)

    user_applicable = client.payment_methods().all_applicable()
    market_allowed = Market(client.attributes.market).payment_methods

    return list(set(user_applicable) & set(market_allowed))