# -*- coding: utf-8 -*-
import mpfs.engine.process
from mpfs.common.errors.billing import BillingInAppUnsupportedStoreIdError
from mpfs.common.static.tags.billing import GOOGLE_PLAY, APPLE_APPSTORE
from mpfs.common.util import from_json
from mpfs.common.util.experiments.logic import experiment_manager
from mpfs.core.billing.inapp import mvp1_sync_logic, sync_logic
from mpfs.core.billing.inapp.product_cards import get_card_class
from mpfs.core.billing.inapp.sync_logic import InAppResyncManager
from mpfs.core.billing.product.constants import SpaceBytes

default_log = mpfs.engine.process.get_default_log()


def inapp_callback(req):
    default_log.info("inapp_callback body: %s", req.http_req.data)
    data = from_json(req.http_req.data)
    trust_subscription_id = data["subscription_id"]
    InAppResyncManager.async_resync_by_trust_subs_id(trust_subscription_id)
    return {"status": "success"}


def process_receipt(req):
    if req.store_id not in (APPLE_APPSTORE, GOOGLE_PLAY):
        raise BillingInAppUnsupportedStoreIdError("%s" % req.store_id)
    data = from_json(req.http_req.data)
    if not experiment_manager.is_feature_active("inapp_v2") and req.store_id != GOOGLE_PLAY:
        mvp1_sync_logic.process_receipt(req.uid, data.get("receipt"), req.store_id)
    else:
        # TODO get currency from QS
        sync_logic.process_receipt(req.uid, data.get("receipt"), req.store_id)


def inapp_product_card(req):
    card = get_card_class(req.store_id)(req.uid)
    return card.format()


def inapp_products(req):
    """Deprecated! Used only for old iOS clients."""
    if req.store_id != APPLE_APPSTORE:
        return {"items": []}


    cards_info = []
    for pid in ("100gb_1m_apple_appstore_2019", "100gb_1y_apple_appstore_2019"):
        cards_info.append(
            {
                "product_id": pid,
                "space": SpaceBytes.gb_100,
                "display_space": 1,
                "display_space_units": "GB",
                "is_best_offer": False,
                "is_yandex_plus": False,
            }
        )
    return {"items": cards_info}
