# -*- coding: utf-8 -*-
import mpfs.engine.process

from mpfs.common.static.tags.billing import *
from mpfs.config import settings
from mpfs.core.services.mediabilling_payments import mediabilling_payment_service
from mpfs.core.queue import mpfs_queue as queue


THIRD_TARIFF_PLUS_PIDS = settings.billing['plus_pids']


log = mpfs.engine.process.get_default_log()


def process_mediabilling_callback(req):
    """
    Обработка коллбека от медиабиллинга.
    """

    # Для быстрого запуска без tvm
    # from mpfs.frontend.api.auth import TVM2
    # try:
    #     TVM2.authorize(req)
    # except MPFSError as e:
    #     error_log.error(e.message)
    #     raise AuthorizationError()

    queue_process_mediabilling_callback(req.uid)


def queue_process_mediabilling_callback(uid):
    """
    https://wiki.yandex-team.ru/mb/intervals/

    Получаем все заказы медиабиллинга и по всем заказам плюсового тарифа запускает обработку.
    Подходящий активный тариф может быть только один.
    """
    mediabilling_data = mediabilling_payment_service.get_last_active_interval_for_pids(uid, THIRD_TARIFF_PLUS_PIDS)

    if mediabilling_data:
        queue.put(mediabilling_data, MEDIABILLING_OK_CALLBACK)
        log.info('callback from mediabilling: %s:%s, status "%s (%s)"' % (uid,
                                                                          mediabilling_data[NUMBER],
                                                                          mediabilling_data[STATUS],
                                                                          mediabilling_data[STATUS_CODE]))
