# -*- coding: utf-8 -*-
"""

MPFS
BILLING

Интерфейсы работы с продуктами

"""

import mpfs.engine.process

from mpfs.common.errors import billing as errors
from mpfs.core.billing.product import ProductCard
from mpfs.core.billing.product.catalog import Catalog
from mpfs.core.billing.client import Client
from mpfs.core.billing.market import Market


log = mpfs.engine.process.get_default_log()
error_log = mpfs.engine.process.get_error_log()

catalog = Catalog()


def product_list(req):
    '''
    Выдать список продуктов
    '''
    if req.uid:
        client = Client(req.uid)
        if not client.attributes.market:
            raise errors.BillingClientNotBindedToMarket(req.uid)
        market = Market(client.attributes.market)
    elif req.market:
        market = Market(req.market)
    else:
        raise errors.BillingWrongMarket()

    qty = None
    if req.group_uids:
        qty = len(req.group_uids.split(','))

    return catalog.pricelist(market, req.line, qty)


def verstka_products(req):
    ip = req.ip or req.request_headers.get('X-Real-Ip')
    return ProductCard.get_current_products_for(req.uid, locale=req.locale, ip=ip)
