# -*- coding: utf-8 -*-
"""

MPFS
BILLING

Интерфейс по разным внутренним ручкам

"""
import calendar
from datetime import datetime

import mpfs.engine.process

from mpfs.config import settings
from mpfs.common.errors import billing as errors
from mpfs.core.billing.client import Client
from mpfs.core.billing.product import Product
from mpfs.core.billing.product.catalog import Catalog
from mpfs.core.billing.market import Market
from mpfs.core.billing.service import Service
from mpfs.core.billing.processing import common
from mpfs.core.billing.processing import repair
from mpfs.core.billing import order
from mpfs.common.static.tags.billing import SID, BTIME
from mpfs.common.static import tags

log = mpfs.engine.process.get_default_log()
error_log = mpfs.engine.process.get_error_log()

catalog = Catalog()


def service_create(req):
    """
    Создать услугу без проверок и смс
    Предварительно пересчитать услуги
    """
    from mpfs.core.user.base import Create, NeedInit
    if req.auto_init_user and int(NeedInit(req.uid)):
        Create(req.uid, type='standart', locale=None, noemail=not(req.send_email))

    client = Client(req.uid)
    repair.recalculate_limit_by_services(req.uid)

    if client.attributes.market:
        market = Market(client.attributes.market)
    elif req.market:
        market = Market(req.market)
    else:
        market = Market(settings.billing['default_market'])

    product = Product(req.pid)
    if product.pid not in catalog.get_pids(market, req.line):
        raise errors.BillingInvalidMarketLineProduct(product.pid)

    service = common.simple_create_service(client, product, attributes=req.attributes, send_email=req.send_email)
    return {'sid': service.sid, 'btime': service.btime}


def service_create_for_ps_billing(req):
    try:
        result = service_create(req)
    except errors.BillingProductIsSingletone as exc:
        log.warn('%s already has service %s', req.uid, req.pid)
        result = {SID: exc.previously_created_service_info.get(SID),
                  BTIME: exc.previously_created_service_info.get(BTIME)}
    return result


def service_delete(req):
    """
    Удалить услугу без проверок и смс
    """
    from mpfs.core.billing import api
    api.service_delete(req.uid, req.sid, req.pid, send_email=req.send_email)


def order_list_history_revise(req):
    """
    Отдаёт данные для сверки с биллингом.

    https://jira.yandex-team.ru/browse/CHEMODAN-13906
    """
    q = {'archive': 1}
    if req.ctime_gt:
        q[tags.billing.CTIME_GT] = req.ctime_gt
    if req.ctime_lt:
        q[tags.billing.CTIME_LT] = req.ctime_lt
    orders = order.OrderList(**q)
    for i in xrange(len(orders)):
        o = orders[i]
        product = Product(o[tags.billing.PID])
        try:
            end_datetime = datetime.utcfromtimestamp(o[tags.billing.CTIME]) + product.get_period()
            end_time = calendar.timegm(end_datetime.utctimetuple())
        except errors.BillingProductHasNoPeriod, e:
            try:
                end_time = product.get_border()
            except errors.BillingProductHasNoBorder, e:
                end_time = None

        data = {
            'number': o[tags.billing.NUMBER],
            'begin_time': o[tags.billing.CTIME],
            'end_time': end_time,
            'price': '%s %s' % (o[tags.billing.PRICE], o[tags.billing.CURRENCY]),
            'state': o[tags.billing.STATE],
            'status_code': o[tags.billing.STATUS_CODE],
        }
        orders[i] = data
    return orders
