# -*- coding: utf-8 -*-
"""

MPFS
BILLING

Класс рынка

"""
from mpfs.config import settings
from mpfs.common.errors import billing as errors
from mpfs.common.static.tags.billing import LINE, CURRENCY, PAYMENTS, REGION, COM


class Market(object):
    DEFAULT = settings.billing['default_market']
    MARKET_FOR_UNSUPPORTED_COUNTRIES = COM

    def __init__(self, market):
        if market not in Market.Available():
            raise errors.BillingWrongMarket(market)
        market_data = settings.billing['markets'][market]

        self.code = market
        self.line = market_data[LINE]
        self.currency = market_data[CURRENCY]
        self.payment_methods = market_data[PAYMENTS]
        self.region = market_data[REGION]

    @classmethod
    def from_country(cls, country):
        return cls(cls.country_to_market(country))

    @staticmethod
    def country_to_market(country):
        return settings.billing['countries_with_specific_markets'].get(country, Market.MARKET_FOR_UNSUPPORTED_COUNTRIES)

    @staticmethod
    def Available():
        return settings.billing['markets'].keys()
