# -*- coding: utf-8 -*-
"""

MPFS
BILLING

Платеж

"""
import mpfs.engine.process

from mpfs.common.util import ctimestamp
from mpfs.common.static.tags.billing import *
from mpfs.common.errors import billing as errors
from mpfs.core.services.billing_service import BB
from mpfs.core.billing.payment.common import CommonPaymentProcessor
from mpfs.core.billing.payment.phone import Phone
from mpfs.core.billing.payment.inapp import InApp
from mpfs.core.billing.payment.yamoney import YandexMoney
from mpfs.core.billing.payment.bankcard import BankCard

log = mpfs.engine.process.get_default_log()
error_log = mpfs.engine.process.get_error_log()

def Payment(client, payment_method, **kwargs):
    '''
    Платежный терминал
    Выбирает нужный процессор и передает управление ему
    ''' 
    for cls in CommonPaymentProcessor.__subclasses__():
        if cls.is_processor_for(payment_method):
          return cls(client, **kwargs)
    raise ValueError(payment_method)
        
     