# -*- coding: utf-8 -*-
"""

MPFS
BILLING

Общий виртуальный способ платежа

"""
import mpfs.engine.process

from mpfs.common.static.tags.billing import *
from mpfs.common.errors import billing as errors
from mpfs.core.services.billing_service import BB
from mpfs.common.util import ctimestamp

log = mpfs.engine.process.get_default_log()
error_log = mpfs.engine.process.get_error_log()


class CommonPaymentProcessor(object):

    type = None
    bb_method_id = None
    need_personal_id = False

    def __init__(self, client, payment_basis=None, callback=None, return_path=None):
        self.client = client
        self.payment_basis = payment_basis
        self.callback = callback
        self.return_path = return_path

    @classmethod
    def is_processor_for(cls, method):
        return cls.type == method

    def make(self, bb_tld=None, template_tag=None, locale=None, pid=None):
        '''
        Проведение платежа
        '''
        payment_methods = self.client.payment_methods()

        if not payment_methods.is_allowed(self.type):
            raise errors.BillingPaymentMethodNotFound(self.client.uid, self.type)

        payment_method_id = \
            payment_methods.get_personal_id(self.type) \
            if self.need_personal_id \
            else self.bb_method_id
        payment_result = BB.payment_make(
            self.client.uid,
            self.payment_basis.number,
            payment_method_id,
            self.client.ip,
            self.callback,
            self.return_path,
            bb_tld=bb_tld,
            template_tag=template_tag,
            locale=locale,
            pid=pid,
        )

        if payment_result and PAYMENT_ID in payment_result:
            # сюда можем попасть только при использовании TrustPaymentsService
            from mpfs.core.billing import Order  # циклический импорт
            order = Order(self.payment_basis.number)
            if not order.auto:
                # для нового апи для обычных заказов необходимо запоминать id оплаты для проверки статуса
                order.set(PAYMENT_ID, payment_result[PAYMENT_ID])
            payment_result.pop(PAYMENT_ID, None)

        return payment_result
