# -*- coding: utf-8 -*-
"""

MPFS
BILLING

Процессинг разных починок/исправлений

"""
from operator import itemgetter

import mpfs.engine.process

from mpfs.common import errors
from mpfs.core.billing.client import Client
from mpfs.core.billing.product import Product
from mpfs.core.billing.service import ServiceCreate, ServiceList, Service
from mpfs.core.filesystem.dao.recount import RecountDAO
from mpfs.core.filesystem.quota import Quota
from mpfs.core.user.constants import *
from mpfs.common.static.tags.billing import *
from mpfs.core.services import passport_service
from mpfs.core.metastorage.control import invite_mpfs_referrals as referrals_table
from mpfs.core.billing.processing.common import calculate_billing_time

log = mpfs.engine.process.get_default_log()
error_log = mpfs.engine.process.get_error_log()
passport = passport_service.Passport()

STATES = SET_STATES_SETTINGS.get(DEFAULT_PROJECT).get('states').get(DEFAULT_NAMESPACE)


def recalculate_limit_by_services(uid, dry_run=False):
    """
    Выставить лимит по услугам из billing_services

    https://st.yandex-team.ru/CHEMODAN-19881
    https://st.yandex-team.ru/CHEMODAN-19050
    """
    quota = Quota()

    # ничего не делаем с юзерами, у которых нет лимита (аттач и пр)
    try:
        current_limit = quota.limit(uid=uid)
    except errors.StorageEmptyDiskInfo:
        return

    client = Client(uid)
    services = ServiceList(client=client)

    log_array = []
    from mpfs.core.user.standart import PAID_PRODUCTS_IDS
    has_paid_services = any([s[PRODUCT].id in PAID_PRODUCTS_IDS for s in services])
    calculated_limit = calculate_limit_by_services(services, log_array)

    log.info('%s limit data: %s' % (uid, log_array))
    log.info('%s calculated limit was %s. Has paid services: %s' % (uid, calculated_limit, has_paid_services))

    if not dry_run:
        from mpfs.core.user.base import User
        user = User(uid)
        user.set_is_paid(has_paid_services)
        if current_limit != calculated_limit:
            quota.set_limit(calculated_limit, uid=uid)
            log.info('%s quota set to %s, was %s' % (uid, calculated_limit, current_limit))

    return calculated_limit


def calculate_limit_by_services(services, log_array=None):
    calculated_limit = 0
    for item in services:
        amount = item[PRODUCT].attributes.amount
        if item.get(GROUP) and item.get(CHILD_SIDS):  # если групповая услуга и я владелец этой группы
            amount = 0
        elif item.get(STATE, None) in ServiceState.not_provide_service:
            amount = 0

        calculated_limit += amount
        if log_array is not None:
            log_array.append(
                {
                    SID: item[SID],
                    PID: item[PID],
                    'size': amount
                }
            )
    return calculated_limit


def repair_services(uid, dry_run=False):
    """
    Тотальный пересчет и проверка всех услуг
    Раньше жило в mpfs-admin-fix-limits.py

    :param uid: uid юзера
    :param force: форсировать изменения или просто выдать в лог
    """
    from mpfs.core.user.base import User
    user = User(uid)
    client = Client(uid)
    existing_def_states = user.states.list_all().get('global', {})
    services = ServiceList(client=client)
    userinfo = passport.userinfo(uid)

    # создаем базовые настройки, если их еще не было
    if not dry_run:
        user.__class__._post_process_user(uid, userinfo, userinfo['language'])

    # делаем карту услуг, сортируем по дате создания
    services_map = {}
    for item in services:
        pid = item[PID]
        if pid in services_map:
            services_map[pid].append(item)
        else:
            services_map[pid] = [item]

    # проходим по карте услуг, готовим кандидатов на удаление
    services_for_delete = []
    for pid, items in services_map.iteritems():
        product = Product(pid)
        if product.singleton and len(items) > 1:
            items.sort(key=itemgetter('ctime'))
            only_one_alive = items.pop(0)
            services_for_delete.extend(items)
            services_map[pid] = [only_one_alive]

    # выставляем обычные состояния
    default_states = {}
    for pid, items in services_map.iteritems():
        pid = 'desktop_installed' if pid == 'app_install' else pid
        if pid in STATES and pid not in existing_def_states:
            default_states[pid] = 1

    # выставляем состояния инвайтов
    invite_states = {
        'activated': 0,
        'bonus_used': 0,
        'bonus_unused': INVITES_REFERRAL_POOL
    }
    invited_success = 0

    try:
        referral_record = referrals_table.value(uid)
        referral_state = referral_record.get('state')
        if referral_state == 'ok':
            invite_states['state'] = 'ok'
    except AttributeError:
        pass

    for item in referrals_table.folder_content(uid):
        friend_state = item['state']
        if friend_state == 'ok':
            invite_states['bonus_used'] += INVITES_REFERRAL_BONUS
            invite_states['bonus_unused'] -= INVITES_REFERRAL_BONUS
            invited_success += 1
        invite_states['activated'] += 1

    referrals = services_map.get('referral', [])
    if len(referrals) < invited_success:
        log.info('%s create referral service, count %s' % (uid, invited_success - len(referrals)))
        if not dry_run:
            for i in xrange(invited_success - len(referrals)):
                product = Product('referral')
                service = ServiceCreate(client, product)
                nbtime, lbtime = calculate_billing_time(service)
                service.set(BTIME, nbtime)
                service.set(LASTBTIME, lbtime)
                service.set(ENABLED, True)

            services = ServiceList(client=client)
            services_map['referral'] = []
            for item in services:
                if item[PID] == 'referral':
                    services_map['referral'].append(item)
    elif len(referrals) > invited_success:
        for i in xrange(len(referrals) - invited_success):
            services_for_delete.append(services_map['referral'].pop(0))

    """
    Проверяем, есть ли услуга дефолтных 3ГБ или 10ГБ
    1. Если нет 3Гб удаляем app_install, promo_shared, file_uploaded если есть
      1.a. Если нет 10Гб - создаем 10Гб
    2. Если есть 3ГБ и нет 10Гб - ничего не делаем
    3. Если есть 3ГБ и есть 10ГБ - удаляем 3ГБ, app_install, promo_shared, file_uploaded
    """
    services_for_create = []
    if 'initial_3gb' not in services_map:
        for pid in ('app_install', 'promo_shared', 'file_uploaded'):
            if pid in services_map:
                services_for_delete.append(services_map[pid].pop(0))
        if 'initial_10gb' not in services_map:
            services_for_create.append('initial_10gb')
    elif 'initial_3gb' in services_map and 'initial_10gb' not in services_map:
        for pid in ('app_install', 'promo_shared', 'file_uploaded'):
            if pid not in services_map:
                services_for_create.append(pid)
    elif 'initial_3gb' in services_map and 'initial_10gb' in services_map:
        for pid in ('initial_3gb', 'app_install', 'promo_shared', 'file_uploaded'):
            if pid in services_map:
                services_for_delete.append(services_map[pid].pop(0))

    # создаем услуги, если надо
    for pid in services_for_create:
        product = Product(pid)
        log.info('%s create service %s' % (uid, pid))
        if not dry_run:
            service = ServiceCreate(client, product)
            nbtime, lbtime = calculate_billing_time(service)
            service.set(BTIME, nbtime)
            service.set(LASTBTIME, lbtime)
            service.set(ENABLED, True)
            item = {PRODUCT: service.product}
        else:
            item = {PRODUCT: Product(pid)}
        services_map[pid] = [item]

    # подсчитываем общий лимит
    limit = DEFAULT_SPACE_LIMIT
    for pid, items in services_map.iteritems():
        for item in items:
            limit += item[PRODUCT].attributes.amount

    log.info('%s final map %s' % (uid, dict(map(lambda x: (x, len(services_map[x])), services_map.iterkeys()))))

    if default_states:
        log.info('%s update disk_info (global) with %s' % (uid, default_states))
        if not dry_run:
            user.states.bulk_set(default_states)

    if invite_states['activated'] != 0 and invite_states['bonus_used'] != 0:
        log.info('%s update disk_info (invite) with %s' % (uid, invite_states))
        if not dry_run:
            user.states.bulk_set(invite_states, namespace='invites')

    log.info('%s set limit at %s' % (uid, limit))
    if not dry_run:
        Quota().set_limit(limit, uid=uid)

    log.info('%s put recount' % uid)
    if not dry_run:
        RecountDAO().add(uid)

    # удаляем ненужные улсуги
    for item in services_for_delete:
        sid, pid = item[SID], item[PID]
        log.info('%s delete service %s:%s' % (uid, pid, sid))

        if not dry_run:
            service = Service(sid)
            service.delete(disable=False)

    return limit

