# -*- coding: utf-8 -*-
"""

MPFS
BILLING

Каталог продуктов
Делаем в коде, потому что пока так проще

"""
import copy


from mpfs.common.static.tags.billing import *
from mpfs.common.errors import billing as errors
from mpfs.core.billing.product.catalog.bonus import bonus_p
from mpfs.core.billing.product.catalog.inapp import InAppProductsHolder
from mpfs.core.billing.product.catalog.partner import partner_p
from mpfs.core.billing.product.catalog.development import dev_p, group_dev_p
from mpfs.core.billing.product.catalog.distribution import dist_p
from mpfs.core.billing.product.catalog.primary_2013 import primary_p_2013
from mpfs.core.billing.product.catalog.primary_2014 import primary_p_2014
from mpfs.core.billing.product.catalog.primary_2015 import primary_p_2015
from mpfs.core.billing.product.catalog.primary_2018 import primary_p_2018
from mpfs.core.billing.product.catalog.primary_2018_discount_10 import primary_p_2018_discount_10
from mpfs.core.billing.product.catalog.primary_2018_discount_20 import primary_p_2018_discount_20
from mpfs.core.billing.product.catalog.primary_2018_discount_30 import primary_p_2018_discount_30
from mpfs.core.billing.product.catalog.primary_2019 import primary_p_2019
from mpfs.core.billing.product.catalog.primary_2019_discount_10 import primary_p_2019_discount_10
from mpfs.core.billing.product.catalog.primary_2019_discount_20 import primary_p_2019_discount_20
from mpfs.core.billing.product.catalog.primary_2019_discount_30 import primary_p_2019_discount_30
from mpfs.core.billing.product.catalog.primary_2019_v2 import primary_p_2019_v2
from mpfs.core.billing.product.catalog.primary_2019_v2_discount_10 import primary_p_2019_v2_discount_10
from mpfs.core.billing.product.catalog.primary_2019_v2_discount_20 import primary_p_2019_v2_discount_20
from mpfs.core.billing.product.catalog.primary_2019_v2_discount_30 import primary_p_2019_v2_discount_30
from mpfs.core.billing.product.catalog.primary_2019_v3 import primary_p_2019_v3
from mpfs.core.billing.product.catalog.primary_2019_v3_discount_10 import primary_p_2019_v3_discount_10
from mpfs.core.billing.product.catalog.primary_2019_v3_discount_20 import primary_p_2019_v3_discount_20
from mpfs.core.billing.product.catalog.primary_2019_v3_discount_30 import primary_p_2019_v3_discount_30
from mpfs.core.billing.product.catalog.primary_2019_v4 import primary_p_2019_v4
from mpfs.core.billing.product.catalog.primary_2019_v4_discount_10 import primary_p_2019_v4_discount_10
from mpfs.core.billing.product.catalog.primary_2019_v4_discount_20 import primary_p_2019_v4_discount_20
from mpfs.core.billing.product.catalog.primary_2019_v4_discount_30 import primary_p_2019_v4_discount_30
from mpfs.core.billing.product.catalog.third_2019 import third_p_2019
from mpfs.core.billing.product.catalog.third_2019_discount_10 import third_p_2019_discount_10
from mpfs.core.billing.product.catalog.third_2019_discount_20 import third_p_2019_discount_20
from mpfs.core.billing.product.catalog.third_2019_discount_30 import third_p_2019_discount_30
from mpfs.core.billing.product.catalog.yandex_plus_upsale_2019 import yandex_plus_upsale_2019
from mpfs.core.billing.product.catalog.yandex import yandex_p
from mpfs.core.billing.product.catalog.group_2016 import group_p_2016
from mpfs.config import settings
from mpfs.core.promo_codes.catalog import (
    promo_code_products,
    promo_code_products_dev,
)
from mpfs.core.rostelecom_unlim.catalog import rostelecom_unlim_products, rostelecom_unlim_test_products

BILLING_GROUP_UIDS_LIMIT = settings.billing['group_uids_limit']


P = partner_p + bonus_p + dev_p + dist_p + primary_p_2013 + primary_p_2014 + primary_p_2015 + primary_p_2018 + \
    primary_p_2018_discount_10 + primary_p_2018_discount_20 + primary_p_2018_discount_30 + yandex_p + group_p_2016 + group_dev_p + \
    promo_code_products + promo_code_products_dev + rostelecom_unlim_products + rostelecom_unlim_test_products + \
    primary_p_2019 + primary_p_2019_discount_10 + primary_p_2019_discount_20 + primary_p_2019_discount_30 + \
    primary_p_2019_v2 + primary_p_2019_v2_discount_10 + primary_p_2019_v2_discount_20 + primary_p_2019_v2_discount_30 + \
    primary_p_2019_v3 + primary_p_2019_v3_discount_10 + primary_p_2019_v3_discount_20 + primary_p_2019_v3_discount_30 + \
    primary_p_2019_v4 + primary_p_2019_v4_discount_10 + primary_p_2019_v4_discount_20 + primary_p_2019_v4_discount_30 + \
    InAppProductsHolder.all_products + yandex_plus_upsale_2019 + third_p_2019 + third_p_2019_discount_10 + third_p_2019_discount_20 +\
    third_p_2019_discount_30

PRIMARY_PRODUCTS = primary_p_2013 + primary_p_2014 + primary_p_2015 + primary_p_2018 + primary_p_2018_discount_10 + \
                   primary_p_2018_discount_20 + primary_p_2018_discount_30 + primary_p_2019 + \
                   primary_p_2019_discount_10 + primary_p_2019_discount_20 + primary_p_2019_discount_30 + \
                   primary_p_2019_v2 + primary_p_2019_v2_discount_10 + primary_p_2019_v2_discount_20 + \
                   primary_p_2019_v2_discount_30 + primary_p_2019_v3 + primary_p_2019_v3_discount_10 + \
                   primary_p_2019_v3_discount_20 + primary_p_2019_v3_discount_30 + primary_p_2019_v4 + \
                   primary_p_2019_v4_discount_10 + primary_p_2019_v4_discount_20 + primary_p_2019_v4_discount_30 + \
                   InAppProductsHolder.all_products + yandex_plus_upsale_2019 + third_p_2019 + third_p_2019_discount_10 + \
                   third_p_2019_discount_20 + third_p_2019_discount_30

PRIMARY_PRODUCTS_IDS = {x['id'] for x in PRIMARY_PRODUCTS}
PRODUCTS = dict([(p[ID], p) for p in P])

ROSTELECOM_UNLIM_PRODUCTS_IDS = {p[ID] for p in rostelecom_unlim_products + rostelecom_unlim_test_products}

PS_BILLING_PRODUCT_IDS = {
    PRODUCTS['yandex_disk_for_business']['id'],
    PRODUCTS['yandex_mail_pro']['id'],  # Диск для Почты Про для b2b
    PRODUCTS['yandex_b2c_mail_pro']['id'],  # Диск для Почты 360
    PRODUCTS['yandex_b2c_mail_pro_promo']['id'],  # Диск для Почты 360
    PRODUCTS['yandex_b2b_mail_pro']['id']  # Диск для Почты 360
}

PARTNERS_PAID_PRODUCTS_IDS = {PRODUCTS['yandex_directory_1tb']['id']} | PS_BILLING_PRODUCT_IDS


def get_group_product_id_by_qty(pid, qty):
    return '%s_%d' % (pid, qty)


def get_unit_price(product, qty):
    """
    Возвращает цену продукта для одного человека в зависимости от количества человек, для которых покупаем
    """
    if qty is None:
        qty = 1

    price = product[PRICE]
    if PRICES_BY_QTY in product:
        if qty in product[PRICES_BY_QTY]:
            price = product[PRICES_BY_QTY][qty]

    return price


def filter_product_fields(product, fields=None):
    if fields:
        for field in fields:
            product.pop(field, None)


def expand_template_product(template):
    result = {}
    for qty in xrange(1, BILLING_GROUP_UIDS_LIMIT + 1):
        product = copy.copy(template)

        product[ID] = get_group_product_id_by_qty(template[ID], qty)
        price = get_unit_price(product, qty)

        product[PRICE] = {cur: val * qty for cur, val in price.iteritems()}
        product[GROUP_SIZE] = qty

        filter_product_fields(product, fields=(PRICES_BY_QTY,))
        result[product[ID]] = product
    return result


# генерируем продукты по шаблонам
GROUP_PRODUCTS = {}
group_product_templates = [p for p in P if p.get(GROUP_TEMPLATE, False)]
for template in group_product_templates:
    GROUP_PRODUCTS.update(expand_template_product(template))


ALL_PRODUCTS = PRODUCTS.copy()
ALL_PRODUCTS.update(GROUP_PRODUCTS)


JOINED_PRODUCTS = {
    'webdav_used': 'app_install',
    'mobile_installed' : 'app_install',
    'desktop_installed': 'app_install',
}

DEFAULT_PARTNER = [
    PRODUCTS['rostelecom_2014_100gb'],
    PRODUCTS['rostelecom_2015_100gb_paid'],
    PRODUCTS['search_app_promo_gift'],
    PRODUCTS['yandex_plus_10gb'],
    PRODUCTS['yandex_directory_1tb'],
    PRODUCTS['yandex_disk_for_business'],
    PRODUCTS['yandex_mail_pro'],
    PRODUCTS['yandex_b2c_mail_pro'],
    PRODUCTS['yandex_b2c_mail_pro_promo'],
    PRODUCTS['yandex_b2b_mail_pro'],
]

DEFAULT_BONUS = [
    PRODUCTS['app_install'],
    PRODUCTS['file_uploaded'],
    PRODUCTS['promo_shared'],
    PRODUCTS['invited'],
    PRODUCTS['referral'],
    PRODUCTS['turkish'],
    PRODUCTS['yandex_staff'],
    PRODUCTS['passport_split'],
    PRODUCTS['music_dec_2012'],
    PRODUCTS['turkey_proje_y'],
    PRODUCTS['turkey_panorama'],
    PRODUCTS['yandex_shad'],
    PRODUCTS['yandex_browser'],
    PRODUCTS['photostream_used'],
    PRODUCTS['yandex_ege'],
    PRODUCTS['blat_250'],
    PRODUCTS['blat_100'],
    PRODUCTS['blat'],
    PRODUCTS['acmicpc'],
    PRODUCTS['yandex_mail_birthday'],
    PRODUCTS['yandex_mail_mobile_app_installation'],
    PRODUCTS['ny_2014'],
    PRODUCTS['20131201_install_fail'],
    PRODUCTS['yandex_video'],
    PRODUCTS['yandex_webchat'],
    PRODUCTS['common_fuckup'],
    PRODUCTS['fotki_closing_compensation'],
    PRODUCTS['yandex_mail_ranktable'],
    PRODUCTS['b2b_1tb'],
    PRODUCTS['b2b_250gb'],
    PRODUCTS['b2b_10gb'],
    PRODUCTS['special_offer_1_tb_for_english_lessons'],
    PRODUCTS['32_gb_autoupload'],
    PRODUCTS['back_to_school'],
    PRODUCTS['force_yandex_pro'],
    PRODUCTS['mail_pro_promo_20gb'],
]

DEFAULT_DISTRIBUTION = [
    PRODUCTS['samsung_ultrabook'],
    PRODUCTS['samsung_notebook'],
    PRODUCTS['sony_notebook'],
    PRODUCTS['sony_tablet'],
    PRODUCTS['samsung_201309'],
    PRODUCTS['yandex_mobile_services'],
    PRODUCTS['media_markt_tablets'],
    PRODUCTS['intel_device'],
    PRODUCTS['kingston_flash'],
]

DEFAULT_PRIMARY_2013 = [
    PRODUCTS['10gb_1m'],
    PRODUCTS['10gb_1y'],
    PRODUCTS['100gb_1m'],
    PRODUCTS['100gb_1y'],
    PRODUCTS['1tb_1m'],
    PRODUCTS['1tb_1y'],
]

DEFAULT_PRIMARY_2014 = [
    PRODUCTS['10gb_1m_2014'],
    PRODUCTS['10gb_1y_2014'],
    PRODUCTS['100gb_1m_2014'],
    PRODUCTS['100gb_1y_2014'],
    PRODUCTS['1tb_1m_2014'],
    PRODUCTS['1tb_1y_2014'],
]

DEFAULT_PRIMARY_2015 = [
    PRODUCTS['10gb_1m_2015'],
    PRODUCTS['10gb_1y_2015'],
    PRODUCTS['10gb_1y_sale_20_2015'],
    PRODUCTS['100gb_1m_2015'],
    PRODUCTS['100gb_1y_2015'],
    PRODUCTS['100gb_1y_sale_20_2015'],
    PRODUCTS['1tb_1m_2015'],
    PRODUCTS['1tb_1y_2015'],
    PRODUCTS['1tb_1y_sale_20_2015'],
]

DEFAULT_GROUP_2016 = [
    PRODUCTS['10gb_1m_2016_group'],
    PRODUCTS['10gb_1y_2016_group'],
    PRODUCTS['100gb_1m_2016_group'],
    PRODUCTS['100gb_1y_2016_group'],
    PRODUCTS['1tb_1m_2016_group'],
    PRODUCTS['1tb_1y_2016_group'],
    PRODUCTS['250gb_forever_2016_group'],
]

DEFAULT_PRIMARY_2018 = [
    PRODUCTS['100gb_1m_2018'],
    PRODUCTS['100gb_1y_2018'],
    PRODUCTS['1tb_1m_2018'],
    PRODUCTS['1tb_1y_2018'],
]

DEFAULT_PRIMARY_2018_DISCOUNT_10 = [
    PRODUCTS['100gb_1m_2018_discount_10'],
    PRODUCTS['100gb_1y_2018_discount_10'],
    PRODUCTS['1tb_1m_2018_discount_10'],
    PRODUCTS['1tb_1y_2018_discount_10'],
]

DEFAULT_PRIMARY_2018_DISCOUNT_20 = [
    PRODUCTS['100gb_1m_2018_discount_20'],
    PRODUCTS['100gb_1y_2018_discount_20'],
    PRODUCTS['1tb_1m_2018_discount_20'],
    PRODUCTS['1tb_1y_2018_discount_20'],
]

DEFAULT_PRIMARY_2018_DISCOUNT_30 = [
    PRODUCTS['100gb_1m_2018_discount_30'],
    PRODUCTS['100gb_1y_2018_discount_30'],
    PRODUCTS['1tb_1m_2018_discount_30'],
    PRODUCTS['1tb_1y_2018_discount_30'],
]

DEFAULT_PRIMARY_2019 = [
    PRODUCTS['100gb_1m_2019'],
    PRODUCTS['100gb_1y_2019'],
    PRODUCTS['1tb_1m_2019'],
    PRODUCTS['1tb_1y_2019'],
]

DEFAULT_PRIMARY_2019_DISCOUNT_10 = [
    PRODUCTS['100gb_1m_2019_discount_10'],
    PRODUCTS['100gb_1y_2019_discount_10'],
    PRODUCTS['1tb_1m_2019_discount_10'],
    PRODUCTS['1tb_1y_2019_discount_10'],
]

DEFAULT_PRIMARY_2019_DISCOUNT_20 = [
    PRODUCTS['100gb_1m_2019_discount_20'],
    PRODUCTS['100gb_1y_2019_discount_20'],
    PRODUCTS['1tb_1m_2019_discount_20'],
    PRODUCTS['1tb_1y_2019_discount_20'],
]

DEFAULT_PRIMARY_2019_DISCOUNT_30 = [
    PRODUCTS['100gb_1m_2019_discount_30'],
    PRODUCTS['100gb_1y_2019_discount_30'],
    PRODUCTS['1tb_1m_2019_discount_30'],
    PRODUCTS['1tb_1y_2019_discount_30'],
]

DEFAULT_PRIMARY_2019_V2 = [
    PRODUCTS['100gb_1m_2019_v2'],
    PRODUCTS['100gb_1y_2019_v2'],
    PRODUCTS['1tb_1m_2019_v2'],
    PRODUCTS['1tb_1y_2019_v2'],
]

DEFAULT_PRIMARY_2019_V2_DISCOUNT_10 = [
    PRODUCTS['100gb_1m_2019_v2_discount_10'],
    PRODUCTS['100gb_1y_2019_v2_discount_10'],
    PRODUCTS['1tb_1m_2019_v2_discount_10'],
    PRODUCTS['1tb_1y_2019_v2_discount_10'],
]

DEFAULT_PRIMARY_2019_V2_DISCOUNT_20 = [
    PRODUCTS['100gb_1m_2019_v2_discount_20'],
    PRODUCTS['100gb_1y_2019_v2_discount_20'],
    PRODUCTS['1tb_1m_2019_v2_discount_20'],
    PRODUCTS['1tb_1y_2019_v2_discount_20'],
]

DEFAULT_PRIMARY_2019_V2_DISCOUNT_30 = [
    PRODUCTS['100gb_1m_2019_v2_discount_30'],
    PRODUCTS['100gb_1y_2019_v2_discount_30'],
    PRODUCTS['1tb_1m_2019_v2_discount_30'],
    PRODUCTS['1tb_1y_2019_v2_discount_30'],
]

DEFAULT_PRIMARY_2019_V3 = [
    PRODUCTS['100gb_1m_2019_v3'],
    PRODUCTS['100gb_1y_2019_v3'],
    PRODUCTS['1tb_1m_2019_v3'],
    PRODUCTS['1tb_1y_2019_v3'],
]

DEFAULT_PRIMARY_2019_V3_DISCOUNT_10 = [
    PRODUCTS['100gb_1m_2019_v3_discount_10'],
    PRODUCTS['100gb_1y_2019_v3_discount_10'],
    PRODUCTS['1tb_1m_2019_v3_discount_10'],
    PRODUCTS['1tb_1y_2019_v3_discount_10'],
]

DEFAULT_PRIMARY_2019_V3_DISCOUNT_20 = [
    PRODUCTS['100gb_1m_2019_v3_discount_20'],
    PRODUCTS['100gb_1y_2019_v3_discount_20'],
    PRODUCTS['1tb_1m_2019_v3_discount_20'],
    PRODUCTS['1tb_1y_2019_v3_discount_20'],
]

DEFAULT_PRIMARY_2019_V3_DISCOUNT_30 = [
    PRODUCTS['100gb_1m_2019_v3_discount_30'],
    PRODUCTS['100gb_1y_2019_v3_discount_30'],
    PRODUCTS['1tb_1m_2019_v3_discount_30'],
    PRODUCTS['1tb_1y_2019_v3_discount_30'],
]

DEFAULT_PRIMARY_2019_V4 = [
    PRODUCTS['100gb_1m_2019_v4'],
    PRODUCTS['100gb_1y_2019_v4'],
    PRODUCTS['1tb_1m_2019_v4'],
    PRODUCTS['1tb_1y_2019_v4'],
]

DEFAULT_PRIMARY_2019_V4_DISCOUNT_10 = [
    PRODUCTS['100gb_1m_2019_v4_discount_10'],
    PRODUCTS['100gb_1y_2019_v4_discount_10'],
    PRODUCTS['1tb_1m_2019_v4_discount_10'],
    PRODUCTS['1tb_1y_2019_v4_discount_10'],
]

DEFAULT_PRIMARY_2019_V4_DISCOUNT_20 = [
    PRODUCTS['100gb_1m_2019_v4_discount_20'],
    PRODUCTS['100gb_1y_2019_v4_discount_20'],
    PRODUCTS['1tb_1m_2019_v4_discount_20'],
    PRODUCTS['1tb_1y_2019_v4_discount_20'],
]

DEFAULT_PRIMARY_2019_V4_DISCOUNT_30 = [
    PRODUCTS['100gb_1m_2019_v4_discount_30'],
    PRODUCTS['100gb_1y_2019_v4_discount_30'],
    PRODUCTS['1tb_1m_2019_v4_discount_30'],
    PRODUCTS['1tb_1y_2019_v4_discount_30'],
]

DEFAULT_YANDEX_PLUS_UPSALE = [
    PRODUCTS['ru.yandex.web.disk.native.1month.autorenewable.notrial.disk_basic.750'],
    PRODUCTS['ru.yandex.web.disk.native.1year.autorenewable.notrial.disk_basic.6500'],
    PRODUCTS['ru.yandex.web.disk.native.1month.autorenewable.notrial.disk_100gb.69']
]

DEFAULT_THIRD_TARIFF_2019 = [
    PRODUCTS['3tb_1m_2019'],
    PRODUCTS['3tb_1y_2019']
]

DEFAULT_THIRD_TARIFF_2019_DISCOUNT_10 = [
    PRODUCTS['3tb_1m_2019_discount_10'],
    PRODUCTS['3tb_1y_2019_discount_10']
]

DEFAULT_THIRD_TARIFF_2019_DISCOUNT_20 = [
    PRODUCTS['3tb_1m_2019_discount_20'],
    PRODUCTS['3tb_1y_2019_discount_20']
]

DEFAULT_THIRD_TARIFF_2019_DISCOUNT_30 = [
    PRODUCTS['3tb_1m_2019_discount_30'],
    PRODUCTS['3tb_1y_2019_discount_30']
]

DEFAULT_PROMO_CODE = [
    PRODUCTS['euroset_1tb_1_year'],
    PRODUCTS['wikium_100_gb_1_year'],
    PRODUCTS['promo_code_blat_100'],
    PRODUCTS['promo_code_blat_100gb_1m'],
    PRODUCTS['promo_code_blat_1tb_1m'],
    PRODUCTS['beeline_armenia_20gb'],
    PRODUCTS['beeline_armenia_30gb'],
    PRODUCTS['beeline_armenia_40gb'],
    PRODUCTS['beeline_armenia_50gb'],
    PRODUCTS['webmaster_competition_joke_30gb'],
    PRODUCTS['webmaster_blat_50gb'],
    PRODUCTS['webmaster_blat_100gb'],
    PRODUCTS['spring_gigabytes_10gb_2018'],
    PRODUCTS['telegram_10gb_2018'],
    PRODUCTS['samsung_kazakhstan_2018'],
    PRODUCTS['yac_2018_participant_100gb_eternal'],
    PRODUCTS['yac_2018_participant_100gb_1y'],
    PRODUCTS['megafon_100gb_1m_2018'],
    PRODUCTS['megafon_1tb_1m_2018'],
    PRODUCTS['megafon_100gb_6m_2018'],
    PRODUCTS['megafon_1tb_6m_2018'],
    PRODUCTS['disk_ny_2019_10gb_1m'],
    PRODUCTS['test_megafon_100gb_1m'],
    PRODUCTS['test_megafon_1tb_1m'],
    PRODUCTS['test_promo_code_1kb_2min'],
    PRODUCTS['test_promo_code_1kb_1m'],
    PRODUCTS['test_promo_code_1kb_1y'],
    PRODUCTS['test_promo_code_1kb_eternal'],
    PRODUCTS['test_assessor_promo_code_service'],
    PRODUCTS['5tb_1y_blogger'],
    PRODUCTS['1tb_eternal'],
    PRODUCTS['1tb_eternal_friends'],
    PRODUCTS['100gb_eternal_friends'],
    PRODUCTS['beeline_256gb_1_year'],
    PRODUCTS['championship_prize_winner_200gb_1_year'],
]

DEFAULT_ROSTELECOM_UNLIM = [
    PRODUCTS['rostelecom_vas_5gb'],
    PRODUCTS['rostelecom_vas_100gb'],
    PRODUCTS['rostelecom_vas_1tb'],
    PRODUCTS['rostelecom_unlim_1'],
    PRODUCTS['rostelecom_unlim_2'],
    PRODUCTS['rostelecom_unlim_3'],
    PRODUCTS['rostelecom_vas_5gb_test'],
    PRODUCTS['rostelecom_vas_100gb_test'],
    PRODUCTS['rostelecom_vas_1tb_test'],
    PRODUCTS['rostelecom_unlim_1_test'],
    PRODUCTS['rostelecom_unlim_2_test'],
    PRODUCTS['rostelecom_unlim_3_test'],
]

DEVELOPMENT_GROUP = [product for pid, product in PRODUCTS.iteritems() if 'test_group' in pid]
DEVELOPMENT_PROMO_CODE = [product for pid, product in PRODUCTS.iteritems() if 'test_promo_code' in pid]


CATALOG = {
    RU: {
        'development': [
            PRODUCTS['test_1kb_eternal'],
            PRODUCTS['test_1kb_for_one_minute'],
            PRODUCTS['test_1kb_for_one_second'],
            PRODUCTS['test_1kb_for_two_seconds'],
            PRODUCTS['test_1kb_for_five_seconds'],
            PRODUCTS['test_1kb_for_five_seconds_with_attrs'],
            PRODUCTS['test_1kb_for_one_month'],
            PRODUCTS['test_1GB_for_five_minutes_for_1_rub'],
            PRODUCTS['test_10GB_for_five_minutes'],
            PRODUCTS['test_10GB_for_10_minutes_with_10m_charging_retry_every_1m'],
            PRODUCTS['test_10GB_for_20_minutes_with_180m_charging_retry_every_10m'],
            PRODUCTS['test_10GB_for_200_minutes_with_180m_charging_retry_every_10m'],
            PRODUCTS['ru.yandex.web.disk.native.20min.autorenewable.notrial.disk_basic.10.debug']
        ] + DEVELOPMENT_GROUP + DEVELOPMENT_PROMO_CODE,
        BONUS: DEFAULT_BONUS,
        PARTNER: DEFAULT_PARTNER,
        DISTRIBUTION: DEFAULT_DISTRIBUTION,
        PRIMARY_2013: DEFAULT_PRIMARY_2013,
        PRIMARY_2014: DEFAULT_PRIMARY_2014,
        PRIMARY_2015: DEFAULT_PRIMARY_2015,
        PRIMARY_2018: DEFAULT_PRIMARY_2018,
        PRIMARY_2018_DISCOUNT_10: DEFAULT_PRIMARY_2018_DISCOUNT_10,
        PRIMARY_2018_DISCOUNT_20: DEFAULT_PRIMARY_2018_DISCOUNT_20,
        PRIMARY_2018_DISCOUNT_30: DEFAULT_PRIMARY_2018_DISCOUNT_30,
        PRIMARY_2019: DEFAULT_PRIMARY_2019,
        PRIMARY_2019_DISCOUNT_10: DEFAULT_PRIMARY_2019_DISCOUNT_10,
        PRIMARY_2019_DISCOUNT_20: DEFAULT_PRIMARY_2019_DISCOUNT_20,
        PRIMARY_2019_DISCOUNT_30: DEFAULT_PRIMARY_2019_DISCOUNT_30,
        PRIMARY_2019_V2: DEFAULT_PRIMARY_2019_V2,
        PRIMARY_2019_V2_DISCOUNT_10: DEFAULT_PRIMARY_2019_V2_DISCOUNT_10,
        PRIMARY_2019_V2_DISCOUNT_20: DEFAULT_PRIMARY_2019_V2_DISCOUNT_20,
        PRIMARY_2019_V2_DISCOUNT_30: DEFAULT_PRIMARY_2019_V2_DISCOUNT_30,
        PRIMARY_2019_V3: DEFAULT_PRIMARY_2019_V3,
        PRIMARY_2019_V3_DISCOUNT_10: DEFAULT_PRIMARY_2019_V3_DISCOUNT_10,
        PRIMARY_2019_V3_DISCOUNT_20: DEFAULT_PRIMARY_2019_V3_DISCOUNT_20,
        PRIMARY_2019_V3_DISCOUNT_30: DEFAULT_PRIMARY_2019_V3_DISCOUNT_30,
        PRIMARY_2019_V4: DEFAULT_PRIMARY_2019_V4,
        PRIMARY_2019_V4_DISCOUNT_10: DEFAULT_PRIMARY_2019_V4_DISCOUNT_10,
        PRIMARY_2019_V4_DISCOUNT_20: DEFAULT_PRIMARY_2019_V4_DISCOUNT_20,
        PRIMARY_2019_V4_DISCOUNT_30: DEFAULT_PRIMARY_2019_V4_DISCOUNT_30,
        INAPP_APPLE_APPSTORE: InAppProductsHolder.apple_appstore_products,
        INAPP_GOOGLE_PLAY: InAppProductsHolder.google_play_products,
        YANDEX_PLUS_UPSALE: DEFAULT_YANDEX_PLUS_UPSALE,  # Только для РФ
        THIRD_TARIFF_2019: DEFAULT_THIRD_TARIFF_2019,
        THIRD_TARIFF_2019_DISCOUNT_10: DEFAULT_THIRD_TARIFF_2019_DISCOUNT_10,
        THIRD_TARIFF_2019_DISCOUNT_20: DEFAULT_THIRD_TARIFF_2019_DISCOUNT_20,
        THIRD_TARIFF_2019_DISCOUNT_30: DEFAULT_THIRD_TARIFF_2019_DISCOUNT_30,
        GROUP_2016: DEFAULT_GROUP_2016,
        PROMO_CODE: DEFAULT_PROMO_CODE,
        ROSTELECOM_UNLIM: DEFAULT_ROSTELECOM_UNLIM,
    },
    TR: {
        'development': [
            PRODUCTS['test_10GB_for_five_minutes'],
        ],
        BONUS: DEFAULT_BONUS,
        PARTNER: DEFAULT_PARTNER,
        DISTRIBUTION: DEFAULT_DISTRIBUTION,
        PRIMARY_2013: DEFAULT_PRIMARY_2013,
        PRIMARY_2014: DEFAULT_PRIMARY_2014,
        PRIMARY_2015: DEFAULT_PRIMARY_2015,
        PRIMARY_2018: DEFAULT_PRIMARY_2018,
        PRIMARY_2018_DISCOUNT_10: DEFAULT_PRIMARY_2018_DISCOUNT_10,
        PRIMARY_2018_DISCOUNT_20: DEFAULT_PRIMARY_2018_DISCOUNT_20,
        PRIMARY_2018_DISCOUNT_30: DEFAULT_PRIMARY_2018_DISCOUNT_30,
        PRIMARY_2019: DEFAULT_PRIMARY_2019,
        PRIMARY_2019_DISCOUNT_10: DEFAULT_PRIMARY_2019_DISCOUNT_10,
        PRIMARY_2019_DISCOUNT_20: DEFAULT_PRIMARY_2019_DISCOUNT_20,
        PRIMARY_2019_DISCOUNT_30: DEFAULT_PRIMARY_2019_DISCOUNT_30,
        PRIMARY_2019_V2: DEFAULT_PRIMARY_2019_V2,
        PRIMARY_2019_V2_DISCOUNT_10: DEFAULT_PRIMARY_2019_V2_DISCOUNT_10,
        PRIMARY_2019_V2_DISCOUNT_20: DEFAULT_PRIMARY_2019_V2_DISCOUNT_20,
        PRIMARY_2019_V2_DISCOUNT_30: DEFAULT_PRIMARY_2019_V2_DISCOUNT_30,
        PRIMARY_2019_V3: DEFAULT_PRIMARY_2019_V3,
        PRIMARY_2019_V3_DISCOUNT_10: DEFAULT_PRIMARY_2019_V3_DISCOUNT_10,
        PRIMARY_2019_V3_DISCOUNT_20: DEFAULT_PRIMARY_2019_V3_DISCOUNT_20,
        PRIMARY_2019_V3_DISCOUNT_30: DEFAULT_PRIMARY_2019_V3_DISCOUNT_30,
        PRIMARY_2019_V4: DEFAULT_PRIMARY_2019_V4,
        PRIMARY_2019_V4_DISCOUNT_10: DEFAULT_PRIMARY_2019_V4_DISCOUNT_10,
        PRIMARY_2019_V4_DISCOUNT_20: DEFAULT_PRIMARY_2019_V4_DISCOUNT_20,
        PRIMARY_2019_V4_DISCOUNT_30: DEFAULT_PRIMARY_2019_V4_DISCOUNT_30,
        THIRD_TARIFF_2019: DEFAULT_THIRD_TARIFF_2019,
        THIRD_TARIFF_2019_DISCOUNT_10: DEFAULT_THIRD_TARIFF_2019_DISCOUNT_10,
        THIRD_TARIFF_2019_DISCOUNT_20: DEFAULT_THIRD_TARIFF_2019_DISCOUNT_20,
        THIRD_TARIFF_2019_DISCOUNT_30: DEFAULT_THIRD_TARIFF_2019_DISCOUNT_30,
        GROUP_2016: DEFAULT_GROUP_2016,
        PROMO_CODE: DEFAULT_PROMO_CODE,
        ROSTELECOM_UNLIM: DEFAULT_ROSTELECOM_UNLIM,
    },
    UK: {
        'development': [
            PRODUCTS['test_10GB_for_five_minutes'],
        ],
        BONUS: DEFAULT_BONUS,
        PARTNER: DEFAULT_PARTNER,
        DISTRIBUTION: DEFAULT_DISTRIBUTION,
        PRIMARY_2013: DEFAULT_PRIMARY_2013,
        PRIMARY_2014: DEFAULT_PRIMARY_2014,
        PRIMARY_2015: DEFAULT_PRIMARY_2015,
        PRIMARY_2018: DEFAULT_PRIMARY_2018,
        PRIMARY_2018_DISCOUNT_10: DEFAULT_PRIMARY_2018_DISCOUNT_10,
        PRIMARY_2018_DISCOUNT_20: DEFAULT_PRIMARY_2018_DISCOUNT_20,
        PRIMARY_2018_DISCOUNT_30: DEFAULT_PRIMARY_2018_DISCOUNT_30,
        PRIMARY_2019: DEFAULT_PRIMARY_2019,
        PRIMARY_2019_DISCOUNT_10: DEFAULT_PRIMARY_2019_DISCOUNT_10,
        PRIMARY_2019_DISCOUNT_20: DEFAULT_PRIMARY_2019_DISCOUNT_20,
        PRIMARY_2019_DISCOUNT_30: DEFAULT_PRIMARY_2019_DISCOUNT_30,
        PRIMARY_2019_V2: DEFAULT_PRIMARY_2019_V2,
        PRIMARY_2019_V2_DISCOUNT_10: DEFAULT_PRIMARY_2019_V2_DISCOUNT_10,
        PRIMARY_2019_V2_DISCOUNT_20: DEFAULT_PRIMARY_2019_V2_DISCOUNT_20,
        PRIMARY_2019_V2_DISCOUNT_30: DEFAULT_PRIMARY_2019_V2_DISCOUNT_30,
        PRIMARY_2019_V3: DEFAULT_PRIMARY_2019_V3,
        PRIMARY_2019_V3_DISCOUNT_10: DEFAULT_PRIMARY_2019_V3_DISCOUNT_10,
        PRIMARY_2019_V3_DISCOUNT_20: DEFAULT_PRIMARY_2019_V3_DISCOUNT_20,
        PRIMARY_2019_V3_DISCOUNT_30: DEFAULT_PRIMARY_2019_V3_DISCOUNT_30,
        PRIMARY_2019_V4: DEFAULT_PRIMARY_2019_V4,
        PRIMARY_2019_V4_DISCOUNT_10: DEFAULT_PRIMARY_2019_V4_DISCOUNT_10,
        PRIMARY_2019_V4_DISCOUNT_20: DEFAULT_PRIMARY_2019_V4_DISCOUNT_20,
        PRIMARY_2019_V4_DISCOUNT_30: DEFAULT_PRIMARY_2019_V4_DISCOUNT_30,
        THIRD_TARIFF_2019: DEFAULT_THIRD_TARIFF_2019,
        THIRD_TARIFF_2019_DISCOUNT_10: DEFAULT_THIRD_TARIFF_2019_DISCOUNT_10,
        THIRD_TARIFF_2019_DISCOUNT_20: DEFAULT_THIRD_TARIFF_2019_DISCOUNT_20,
        THIRD_TARIFF_2019_DISCOUNT_30: DEFAULT_THIRD_TARIFF_2019_DISCOUNT_30,
        GROUP_2016: DEFAULT_GROUP_2016,
        PROMO_CODE: DEFAULT_PROMO_CODE,
        ROSTELECOM_UNLIM: DEFAULT_ROSTELECOM_UNLIM,
    },
    COM: {
        'development': [
            PRODUCTS['test_10GB_for_five_minutes'],
        ],
        BONUS: DEFAULT_BONUS,
        PARTNER: DEFAULT_PARTNER,
        DISTRIBUTION: DEFAULT_DISTRIBUTION,
        PRIMARY_2013: DEFAULT_PRIMARY_2013,
        PRIMARY_2014: DEFAULT_PRIMARY_2014,
        PRIMARY_2015: DEFAULT_PRIMARY_2015,
        PRIMARY_2018: DEFAULT_PRIMARY_2018,
        PRIMARY_2018_DISCOUNT_10: DEFAULT_PRIMARY_2018_DISCOUNT_10,
        PRIMARY_2018_DISCOUNT_20: DEFAULT_PRIMARY_2018_DISCOUNT_20,
        PRIMARY_2018_DISCOUNT_30: DEFAULT_PRIMARY_2018_DISCOUNT_30,
        PRIMARY_2019: DEFAULT_PRIMARY_2019,
        PRIMARY_2019_DISCOUNT_10: DEFAULT_PRIMARY_2019_DISCOUNT_10,
        PRIMARY_2019_DISCOUNT_20: DEFAULT_PRIMARY_2019_DISCOUNT_20,
        PRIMARY_2019_DISCOUNT_30: DEFAULT_PRIMARY_2019_DISCOUNT_30,
        PRIMARY_2019_V2: DEFAULT_PRIMARY_2019_V2,
        PRIMARY_2019_V2_DISCOUNT_10: DEFAULT_PRIMARY_2019_V2_DISCOUNT_10,
        PRIMARY_2019_V2_DISCOUNT_20: DEFAULT_PRIMARY_2019_V2_DISCOUNT_20,
        PRIMARY_2019_V2_DISCOUNT_30: DEFAULT_PRIMARY_2019_V2_DISCOUNT_30,
        PRIMARY_2019_V3: DEFAULT_PRIMARY_2019_V3,
        PRIMARY_2019_V3_DISCOUNT_10: DEFAULT_PRIMARY_2019_V3_DISCOUNT_10,
        PRIMARY_2019_V3_DISCOUNT_20: DEFAULT_PRIMARY_2019_V3_DISCOUNT_20,
        PRIMARY_2019_V3_DISCOUNT_30: DEFAULT_PRIMARY_2019_V3_DISCOUNT_30,
        PRIMARY_2019_V4: DEFAULT_PRIMARY_2019_V4,
        PRIMARY_2019_V4_DISCOUNT_10: DEFAULT_PRIMARY_2019_V4_DISCOUNT_10,
        PRIMARY_2019_V4_DISCOUNT_20: DEFAULT_PRIMARY_2019_V4_DISCOUNT_20,
        PRIMARY_2019_V4_DISCOUNT_30: DEFAULT_PRIMARY_2019_V4_DISCOUNT_30,
        THIRD_TARIFF_2019: DEFAULT_THIRD_TARIFF_2019,
        THIRD_TARIFF_2019_DISCOUNT_10: DEFAULT_THIRD_TARIFF_2019_DISCOUNT_10,
        THIRD_TARIFF_2019_DISCOUNT_20: DEFAULT_THIRD_TARIFF_2019_DISCOUNT_20,
        THIRD_TARIFF_2019_DISCOUNT_30: DEFAULT_THIRD_TARIFF_2019_DISCOUNT_30,
        GROUP_2016: DEFAULT_GROUP_2016,
        PROMO_CODE: DEFAULT_PROMO_CODE,
        ROSTELECOM_UNLIM: DEFAULT_ROSTELECOM_UNLIM,
    }
}


class Catalog(object):

    def product(self, pid):
        try:
            return ALL_PRODUCTS[pid]
        except Exception:
            raise errors.BillingProductNotFound(pid)

    def pricelist(self, market, line=None, quantity=None):
        if not line:
            line = market.line

        currency = market.currency
        allowed_methods = market.payment_methods

        result = []
        for product in CATALOG[market.code].get(line, []):
            p = copy.copy(product)
            price = get_unit_price(p, quantity)
            p[PRICE] = {currency: price[currency]}
            p[NAME] = {market.code: p[NAME]}

            filter_product_fields(p, fields=(PRICES_BY_QTY,))
            result.append(p)
        return result

    def get_pids(self, market, line, expand_group_templates=False):
        result = []
        for product in CATALOG[market.code].get(line, []):
            if expand_group_templates and product.get(GROUP_TEMPLATE, False):
                result += [get_group_product_id_by_qty(product[ID], qty)
                           for qty in xrange(1, BILLING_GROUP_UIDS_LIMIT + 1)]
            else:
                result.append(product[ID])
        return result

    def joined_product(self, key):
        return JOINED_PRODUCTS.get(key)

    def all_products(self):
        return PRODUCTS.keys()
